package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{Arn, Identifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExtensionAssociationSummary(
    id: Optional[Identifier] = Optional.Absent,
    extensionArn: Optional[Arn] = Optional.Absent,
    resourceArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ExtensionAssociationSummary = {
    import ExtensionAssociationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ExtensionAssociationSummary
      .builder()
      .optionallyWith(
        id.map(value => Identifier.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        extensionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.extensionArn)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.ExtensionAssociationSummary.ReadOnly =
    zio.aws.appconfig.model.ExtensionAssociationSummary.wrap(buildAwsValue())
}
object ExtensionAssociationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ExtensionAssociationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ExtensionAssociationSummary =
      zio.aws.appconfig.model.ExtensionAssociationSummary(
        id.map(value => value),
        extensionArn.map(value => value),
        resourceArn.map(value => value)
      )
    def id: Optional[Identifier]
    def extensionArn: Optional[Arn]
    def resourceArn: Optional[Arn]
    def getId: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("id", id)
    def getExtensionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("extensionArn", extensionArn)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ExtensionAssociationSummary
  ) extends zio.aws.appconfig.model.ExtensionAssociationSummary.ReadOnly {
    override val id: Optional[Identifier] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Identifier(value))
    override val extensionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.extensionArn())
      .map(value => zio.aws.appconfig.model.primitives.Arn(value))
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.appconfig.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ExtensionAssociationSummary
  ): zio.aws.appconfig.model.ExtensionAssociationSummary.ReadOnly = new Wrapper(
    impl
  )
}
