package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{Arn, Description, Name, Id}
import scala.jdk.CollectionConverters.*
final case class ExtensionSummary(
    id: Optional[Id] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer] =
      Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ExtensionSummary = {
    import ExtensionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ExtensionSummary
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(versionNumber.map(value => value: Integer))(
        _.versionNumber
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.ExtensionSummary.ReadOnly =
    zio.aws.appconfig.model.ExtensionSummary.wrap(buildAwsValue())
}
object ExtensionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ExtensionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ExtensionSummary =
      zio.aws.appconfig.model.ExtensionSummary(
        id.map(value => value),
        name.map(value => value),
        versionNumber.map(value => value),
        arn.map(value => value),
        description.map(value => value)
      )
    def id: Optional[Id]
    def name: Optional[Name]
    def versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer]
    def arn: Optional[Arn]
    def description: Optional[Description]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ExtensionSummary
  ) extends zio.aws.appconfig.model.ExtensionSummary.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val versionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appconfig.model.primitives.Arn(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ExtensionSummary
  ): zio.aws.appconfig.model.ExtensionSummary.ReadOnly = new Wrapper(impl)
}
