package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  StringWithLengthBetween1And255,
  Description,
  Id
}
import scala.jdk.CollectionConverters.*
final case class HostedConfigurationVersionSummary(
    applicationId: Optional[Id] = Optional.Absent,
    configurationProfileId: Optional[Id] = Optional.Absent,
    versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    contentType: Optional[StringWithLengthBetween1And255] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.HostedConfigurationVersionSummary = {
    import HostedConfigurationVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.HostedConfigurationVersionSummary
      .builder()
      .optionallyWith(
        applicationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(
        configurationProfileId.map(value => Id.unwrap(value): java.lang.String)
      )(_.configurationProfileId)
      .optionallyWith(versionNumber.map(value => value: Integer))(
        _.versionNumber
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        contentType.map(value =>
          StringWithLengthBetween1And255.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.HostedConfigurationVersionSummary.ReadOnly =
    zio.aws.appconfig.model.HostedConfigurationVersionSummary
      .wrap(buildAwsValue())
}
object HostedConfigurationVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.HostedConfigurationVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.HostedConfigurationVersionSummary =
      zio.aws.appconfig.model.HostedConfigurationVersionSummary(
        applicationId.map(value => value),
        configurationProfileId.map(value => value),
        versionNumber.map(value => value),
        description.map(value => value),
        contentType.map(value => value)
      )
    def applicationId: Optional[Id]
    def configurationProfileId: Optional[Id]
    def versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer]
    def description: Optional[Description]
    def contentType: Optional[StringWithLengthBetween1And255]
    def getApplicationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getConfigurationProfileId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("configurationProfileId", configurationProfileId)
    def getVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getContentType: ZIO[Any, AwsError, StringWithLengthBetween1And255] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.HostedConfigurationVersionSummary
  ) extends zio.aws.appconfig.model.HostedConfigurationVersionSummary.ReadOnly {
    override val applicationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val configurationProfileId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationProfileId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val versionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val contentType: Optional[StringWithLengthBetween1And255] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentType())
        .map(value =>
          zio.aws.appconfig.model.primitives
            .StringWithLengthBetween1And255(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.HostedConfigurationVersionSummary
  ): zio.aws.appconfig.model.HostedConfigurationVersionSummary.ReadOnly =
    new Wrapper(impl)
}
