package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{NextToken, MaxResults, Id}
import scala.jdk.CollectionConverters.*
final case class ListDeploymentsRequest(
    applicationId: Id,
    environmentId: Id,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest = {
    import ListDeploymentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .environmentId(Id.unwrap(environmentId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.ListDeploymentsRequest.ReadOnly =
    zio.aws.appconfig.model.ListDeploymentsRequest.wrap(buildAwsValue())
}
object ListDeploymentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ListDeploymentsRequest =
      zio.aws.appconfig.model.ListDeploymentsRequest(
        applicationId,
        environmentId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def applicationId: Id
    def environmentId: Id
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getEnvironmentId: ZIO[Any, Nothing, Id] = ZIO.succeed(environmentId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest
  ) extends zio.aws.appconfig.model.ListDeploymentsRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val environmentId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.environmentId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appconfig.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest
  ): zio.aws.appconfig.model.ListDeploymentsRequest.ReadOnly = new Wrapper(impl)
}
