package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  NextToken,
  Identifier,
  Arn,
  MaxResults
}
import scala.jdk.CollectionConverters.*
final case class ListExtensionAssociationsRequest(
    resourceIdentifier: Optional[Arn] = Optional.Absent,
    extensionIdentifier: Optional[Identifier] = Optional.Absent,
    extensionVersionNumber: Optional[
      zio.aws.appconfig.model.primitives.Integer
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest = {
    import ListExtensionAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest
      .builder()
      .optionallyWith(
        resourceIdentifier.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceIdentifier)
      .optionallyWith(
        extensionIdentifier.map(value =>
          Identifier.unwrap(value): java.lang.String
        )
      )(_.extensionIdentifier)
      .optionallyWith(extensionVersionNumber.map(value => value: Integer))(
        _.extensionVersionNumber
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.ListExtensionAssociationsRequest.ReadOnly =
    zio.aws.appconfig.model.ListExtensionAssociationsRequest
      .wrap(buildAwsValue())
}
object ListExtensionAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ListExtensionAssociationsRequest =
      zio.aws.appconfig.model.ListExtensionAssociationsRequest(
        resourceIdentifier.map(value => value),
        extensionIdentifier.map(value => value),
        extensionVersionNumber.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceIdentifier: Optional[Arn]
    def extensionIdentifier: Optional[Identifier]
    def extensionVersionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getResourceIdentifier: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getExtensionIdentifier: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("extensionIdentifier", extensionIdentifier)
    def getExtensionVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "extensionVersionNumber",
        extensionVersionNumber
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest
  ) extends zio.aws.appconfig.model.ListExtensionAssociationsRequest.ReadOnly {
    override val resourceIdentifier: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIdentifier())
      .map(value => zio.aws.appconfig.model.primitives.Arn(value))
    override val extensionIdentifier: Optional[Identifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extensionIdentifier())
        .map(value => zio.aws.appconfig.model.primitives.Identifier(value))
    override val extensionVersionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extensionVersionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appconfig.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest
  ): zio.aws.appconfig.model.ListExtensionAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
