package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListExtensionAssociationsResponse(
    items: Optional[
      Iterable[zio.aws.appconfig.model.ExtensionAssociationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse = {
    import ListExtensionAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.ListExtensionAssociationsResponse.ReadOnly =
    zio.aws.appconfig.model.ListExtensionAssociationsResponse
      .wrap(buildAwsValue())
}
object ListExtensionAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ListExtensionAssociationsResponse =
      zio.aws.appconfig.model.ListExtensionAssociationsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[
      List[zio.aws.appconfig.model.ExtensionAssociationSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.appconfig.model.ExtensionAssociationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse
  ) extends zio.aws.appconfig.model.ListExtensionAssociationsResponse.ReadOnly {
    override val items: Optional[
      List[zio.aws.appconfig.model.ExtensionAssociationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appconfig.model.ExtensionAssociationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse
  ): zio.aws.appconfig.model.ListExtensionAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
