package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{QueryName, NextToken, MaxResults}
import scala.jdk.CollectionConverters.*
final case class ListExtensionsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    name: Optional[QueryName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest = {
    import ListExtensionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        name.map(value => QueryName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.ListExtensionsRequest.ReadOnly =
    zio.aws.appconfig.model.ListExtensionsRequest.wrap(buildAwsValue())
}
object ListExtensionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ListExtensionsRequest =
      zio.aws.appconfig.model.ListExtensionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        name.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def name: Optional[QueryName]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getName: ZIO[Any, AwsError, QueryName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest
  ) extends zio.aws.appconfig.model.ListExtensionsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appconfig.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
    override val name: Optional[QueryName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.QueryName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest
  ): zio.aws.appconfig.model.ListExtensionsRequest.ReadOnly = new Wrapper(impl)
}
