package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListExtensionsResponse(
    items: Optional[Iterable[zio.aws.appconfig.model.ExtensionSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse = {
    import ListExtensionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.ListExtensionsResponse.ReadOnly =
    zio.aws.appconfig.model.ListExtensionsResponse.wrap(buildAwsValue())
}
object ListExtensionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ListExtensionsResponse =
      zio.aws.appconfig.model.ListExtensionsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.appconfig.model.ExtensionSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.appconfig.model.ExtensionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse
  ) extends zio.aws.appconfig.model.ListExtensionsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.appconfig.model.ExtensionSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.ExtensionSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse
  ): zio.aws.appconfig.model.ListExtensionsResponse.ReadOnly = new Wrapper(impl)
}
