package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{Name, Description, Identifier}
import scala.jdk.CollectionConverters.*
final case class UpdateExtensionRequest(
    extensionIdentifier: Identifier,
    description: Optional[Description] = Optional.Absent,
    actions: Optional[Map[zio.aws.appconfig.model.ActionPoint, Iterable[
      zio.aws.appconfig.model.Action
    ]]] = Optional.Absent,
    parameters: Optional[Map[Name, zio.aws.appconfig.model.Parameter]] =
      Optional.Absent,
    versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.UpdateExtensionRequest = {
    import UpdateExtensionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.UpdateExtensionRequest
      .builder()
      .extensionIdentifier(
        Identifier.unwrap(extensionIdentifier): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        actions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.actionsWithStrings)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(versionNumber.map(value => value: Integer))(
        _.versionNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.UpdateExtensionRequest.ReadOnly =
    zio.aws.appconfig.model.UpdateExtensionRequest.wrap(buildAwsValue())
}
object UpdateExtensionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.UpdateExtensionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.UpdateExtensionRequest =
      zio.aws.appconfig.model.UpdateExtensionRequest(
        extensionIdentifier,
        description.map(value => value),
        actions.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        versionNumber.map(value => value)
      )
    def extensionIdentifier: Identifier
    def description: Optional[Description]
    def actions: Optional[Map[zio.aws.appconfig.model.ActionPoint, List[
      zio.aws.appconfig.model.Action.ReadOnly
    ]]]
    def parameters
        : Optional[Map[Name, zio.aws.appconfig.model.Parameter.ReadOnly]]
    def versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer]
    def getExtensionIdentifier: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(extensionIdentifier)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getActions
        : ZIO[Any, AwsError, Map[zio.aws.appconfig.model.ActionPoint, List[
          zio.aws.appconfig.model.Action.ReadOnly
        ]]] = AwsError.unwrapOptionField("actions", actions)
    def getParameters: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.appconfig.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateExtensionRequest
  ) extends zio.aws.appconfig.model.UpdateExtensionRequest.ReadOnly {
    override val extensionIdentifier: Identifier =
      zio.aws.appconfig.model.primitives.Identifier(impl.extensionIdentifier())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val actions
        : Optional[Map[zio.aws.appconfig.model.ActionPoint, List[
          zio.aws.appconfig.model.Action.ReadOnly
        ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.actions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appconfig.model.ActionPoint.wrap(key) -> value.asScala.map {
              item =>
                zio.aws.appconfig.model.Action.wrap(item)
            }.toList
          })
          .toMap
      )
    override val parameters
        : Optional[Map[Name, zio.aws.appconfig.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appconfig.model.primitives
                .Name(key) -> zio.aws.appconfig.model.Parameter.wrap(value)
            })
            .toMap
        )
    override val versionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateExtensionRequest
  ): zio.aws.appconfig.model.UpdateExtensionRequest.ReadOnly = new Wrapper(impl)
}
