package zio.aws.appflow
import zio.aws.appflow.model.StopFlowResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.appflow.model.{
  DeleteFlowRequest,
  DescribeConnectorEntityRequest,
  DeleteConnectorProfileRequest,
  StartFlowRequest,
  DescribeFlowExecutionRecordsRequest,
  DescribeConnectorRequest,
  StopFlowRequest,
  DescribeConnectorsRequest,
  ListTagsForResourceRequest,
  ListConnectorEntitiesRequest,
  ListFlowsRequest,
  RegisterConnectorRequest,
  DescribeConnectorProfilesRequest,
  CreateConnectorProfileRequest,
  ListConnectorsRequest,
  UpdateFlowRequest,
  UntagResourceRequest,
  UnregisterConnectorRequest,
  DescribeFlowRequest,
  CreateFlowRequest,
  UpdateConnectorProfileRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.appflow.{
  AppflowAsyncClientBuilder,
  AppflowAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.appflow.model.{
  ListConnectorEntitiesResponse,
  UpdateConnectorProfileResponse,
  ListFlowsResponse,
  ListConnectorsResponse,
  CreateFlowResponse,
  DescribeFlowExecutionRecordsResponse,
  RegisterConnectorResponse,
  StartFlowResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateConnectorProfileResponse,
  DescribeConnectorEntityResponse,
  DescribeConnectorProfilesResponse,
  StopFlowResponse,
  DescribeConnectorResponse,
  TagResourceResponse,
  DeleteFlowResponse,
  UpdateFlowResponse,
  DescribeConnectorsResponse,
  UnregisterConnectorResponse,
  DeleteConnectorProfileResponse,
  DescribeFlowResponse
}
import scala.jdk.CollectionConverters._
trait Appflow extends AspectSupport[Appflow] {
  val api: AppflowAsyncClient
  def stopFlow(request: StopFlowRequest): IO[AwsError, ReadOnly]
  def startFlow(
      request: StartFlowRequest
  ): IO[AwsError, zio.aws.appflow.model.StartFlowResponse.ReadOnly]
  def updateFlow(
      request: UpdateFlowRequest
  ): IO[AwsError, zio.aws.appflow.model.UpdateFlowResponse.ReadOnly]
  def createConnectorProfile(
      request: CreateConnectorProfileRequest
  ): IO[AwsError, zio.aws.appflow.model.CreateConnectorProfileResponse.ReadOnly]
  def registerConnector(
      request: RegisterConnectorRequest
  ): IO[AwsError, zio.aws.appflow.model.RegisterConnectorResponse.ReadOnly]
  def deleteFlow(
      request: DeleteFlowRequest
  ): IO[AwsError, zio.aws.appflow.model.DeleteFlowResponse.ReadOnly]
  def describeConnector(
      request: DescribeConnectorRequest
  ): IO[AwsError, zio.aws.appflow.model.DescribeConnectorResponse.ReadOnly]
  def listFlows(
      request: ListFlowsRequest
  ): IO[AwsError, zio.aws.appflow.model.ListFlowsResponse.ReadOnly]
  def deleteConnectorProfile(
      request: DeleteConnectorProfileRequest
  ): IO[AwsError, zio.aws.appflow.model.DeleteConnectorProfileResponse.ReadOnly]
  def describeFlowExecutionRecords(
      request: DescribeFlowExecutionRecordsRequest
  ): IO[
    AwsError,
    zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.appflow.model.UntagResourceResponse.ReadOnly]
  def describeFlow(
      request: DescribeFlowRequest
  ): IO[AwsError, zio.aws.appflow.model.DescribeFlowResponse.ReadOnly]
  def listConnectorEntities(
      request: ListConnectorEntitiesRequest
  ): IO[AwsError, zio.aws.appflow.model.ListConnectorEntitiesResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.appflow.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.appflow.model.TagResourceResponse.ReadOnly]
  def updateConnectorProfile(
      request: UpdateConnectorProfileRequest
  ): IO[AwsError, zio.aws.appflow.model.UpdateConnectorProfileResponse.ReadOnly]
  def describeConnectorProfiles(request: DescribeConnectorProfilesRequest): IO[
    AwsError,
    zio.aws.appflow.model.DescribeConnectorProfilesResponse.ReadOnly
  ]
  def describeConnectors(
      request: DescribeConnectorsRequest
  ): IO[AwsError, zio.aws.appflow.model.DescribeConnectorsResponse.ReadOnly]
  def describeConnectorEntity(request: DescribeConnectorEntityRequest): IO[
    AwsError,
    zio.aws.appflow.model.DescribeConnectorEntityResponse.ReadOnly
  ]
  def createFlow(
      request: CreateFlowRequest
  ): IO[AwsError, zio.aws.appflow.model.CreateFlowResponse.ReadOnly]
  def unregisterConnector(
      request: UnregisterConnectorRequest
  ): IO[AwsError, zio.aws.appflow.model.UnregisterConnectorResponse.ReadOnly]
  def listConnectors(
      request: ListConnectorsRequest
  ): IO[AwsError, zio.aws.appflow.model.ListConnectorsResponse.ReadOnly]
}
object Appflow {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Appflow] = customized(
    identity
  )
  def customized(
      customization: AppflowAsyncClientBuilder => AppflowAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Appflow] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AppflowAsyncClientBuilder => AppflowAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Appflow] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AppflowAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[AppflowAsyncClient, AppflowAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[AppflowAsyncClient, AppflowAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new AppflowImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AppflowImpl[R](
      override val api: AppflowAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Appflow
      with AwsServiceBase[R] {
    override val serviceName: String = "Appflow"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AppflowImpl[R1] = new AppflowImpl(api, newAspect, r)
    def stopFlow(request: StopFlowRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.StopFlowRequest,
        StopFlowResponse
      ]("stopFlow", api.stopFlow)(request.buildAwsValue())
        .map(zio.aws.appflow.model.StopFlowResponse.wrap)
        .provideEnvironment(r)
    def startFlow(
        request: StartFlowRequest
    ): IO[AwsError, zio.aws.appflow.model.StartFlowResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.StartFlowRequest,
        StartFlowResponse
      ]("startFlow", api.startFlow)(request.buildAwsValue())
        .map(zio.aws.appflow.model.StartFlowResponse.wrap)
        .provideEnvironment(r)
    def updateFlow(
        request: UpdateFlowRequest
    ): IO[AwsError, zio.aws.appflow.model.UpdateFlowResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.UpdateFlowRequest,
        UpdateFlowResponse
      ]("updateFlow", api.updateFlow)(request.buildAwsValue())
        .map(zio.aws.appflow.model.UpdateFlowResponse.wrap)
        .provideEnvironment(r)
    def createConnectorProfile(request: CreateConnectorProfileRequest): IO[
      AwsError,
      zio.aws.appflow.model.CreateConnectorProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appflow.model.CreateConnectorProfileRequest,
      CreateConnectorProfileResponse
    ]("createConnectorProfile", api.createConnectorProfile)(
      request.buildAwsValue()
    ).map(zio.aws.appflow.model.CreateConnectorProfileResponse.wrap)
      .provideEnvironment(r)
    def registerConnector(
        request: RegisterConnectorRequest
    ): IO[AwsError, zio.aws.appflow.model.RegisterConnectorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.RegisterConnectorRequest,
        RegisterConnectorResponse
      ]("registerConnector", api.registerConnector)(request.buildAwsValue())
        .map(zio.aws.appflow.model.RegisterConnectorResponse.wrap)
        .provideEnvironment(r)
    def deleteFlow(
        request: DeleteFlowRequest
    ): IO[AwsError, zio.aws.appflow.model.DeleteFlowResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.DeleteFlowRequest,
        DeleteFlowResponse
      ]("deleteFlow", api.deleteFlow)(request.buildAwsValue())
        .map(zio.aws.appflow.model.DeleteFlowResponse.wrap)
        .provideEnvironment(r)
    def describeConnector(
        request: DescribeConnectorRequest
    ): IO[AwsError, zio.aws.appflow.model.DescribeConnectorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.DescribeConnectorRequest,
        DescribeConnectorResponse
      ]("describeConnector", api.describeConnector)(request.buildAwsValue())
        .map(zio.aws.appflow.model.DescribeConnectorResponse.wrap)
        .provideEnvironment(r)
    def listFlows(
        request: ListFlowsRequest
    ): IO[AwsError, zio.aws.appflow.model.ListFlowsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.ListFlowsRequest,
        ListFlowsResponse
      ]("listFlows", api.listFlows)(request.buildAwsValue())
        .map(zio.aws.appflow.model.ListFlowsResponse.wrap)
        .provideEnvironment(r)
    def deleteConnectorProfile(request: DeleteConnectorProfileRequest): IO[
      AwsError,
      zio.aws.appflow.model.DeleteConnectorProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileRequest,
      DeleteConnectorProfileResponse
    ]("deleteConnectorProfile", api.deleteConnectorProfile)(
      request.buildAwsValue()
    ).map(zio.aws.appflow.model.DeleteConnectorProfileResponse.wrap)
      .provideEnvironment(r)
    def describeFlowExecutionRecords(
        request: DescribeFlowExecutionRecordsRequest
    ): IO[
      AwsError,
      zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest,
      DescribeFlowExecutionRecordsResponse
    ]("describeFlowExecutionRecords", api.describeFlowExecutionRecords)(
      request.buildAwsValue()
    ).map(zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.appflow.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.appflow.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeFlow(
        request: DescribeFlowRequest
    ): IO[AwsError, zio.aws.appflow.model.DescribeFlowResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.DescribeFlowRequest,
        DescribeFlowResponse
      ]("describeFlow", api.describeFlow)(request.buildAwsValue())
        .map(zio.aws.appflow.model.DescribeFlowResponse.wrap)
        .provideEnvironment(r)
    def listConnectorEntities(request: ListConnectorEntitiesRequest): IO[
      AwsError,
      zio.aws.appflow.model.ListConnectorEntitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesRequest,
      ListConnectorEntitiesResponse
    ]("listConnectorEntities", api.listConnectorEntities)(
      request.buildAwsValue()
    ).map(zio.aws.appflow.model.ListConnectorEntitiesResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.appflow.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appflow.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.appflow.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.appflow.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.appflow.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateConnectorProfile(request: UpdateConnectorProfileRequest): IO[
      AwsError,
      zio.aws.appflow.model.UpdateConnectorProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileRequest,
      UpdateConnectorProfileResponse
    ]("updateConnectorProfile", api.updateConnectorProfile)(
      request.buildAwsValue()
    ).map(zio.aws.appflow.model.UpdateConnectorProfileResponse.wrap)
      .provideEnvironment(r)
    def describeConnectorProfiles(
        request: DescribeConnectorProfilesRequest
    ): IO[
      AwsError,
      zio.aws.appflow.model.DescribeConnectorProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest,
      DescribeConnectorProfilesResponse
    ]("describeConnectorProfiles", api.describeConnectorProfiles)(
      request.buildAwsValue()
    ).map(zio.aws.appflow.model.DescribeConnectorProfilesResponse.wrap)
      .provideEnvironment(r)
    def describeConnectors(
        request: DescribeConnectorsRequest
    ): IO[AwsError, zio.aws.appflow.model.DescribeConnectorsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest,
        DescribeConnectorsResponse
      ]("describeConnectors", api.describeConnectors)(request.buildAwsValue())
        .map(zio.aws.appflow.model.DescribeConnectorsResponse.wrap)
        .provideEnvironment(r)
    def describeConnectorEntity(request: DescribeConnectorEntityRequest): IO[
      AwsError,
      zio.aws.appflow.model.DescribeConnectorEntityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityRequest,
      DescribeConnectorEntityResponse
    ]("describeConnectorEntity", api.describeConnectorEntity)(
      request.buildAwsValue()
    ).map(zio.aws.appflow.model.DescribeConnectorEntityResponse.wrap)
      .provideEnvironment(r)
    def createFlow(
        request: CreateFlowRequest
    ): IO[AwsError, zio.aws.appflow.model.CreateFlowResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.CreateFlowRequest,
        CreateFlowResponse
      ]("createFlow", api.createFlow)(request.buildAwsValue())
        .map(zio.aws.appflow.model.CreateFlowResponse.wrap)
        .provideEnvironment(r)
    def unregisterConnector(request: UnregisterConnectorRequest): IO[
      AwsError,
      zio.aws.appflow.model.UnregisterConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appflow.model.UnregisterConnectorRequest,
      UnregisterConnectorResponse
    ]("unregisterConnector", api.unregisterConnector)(request.buildAwsValue())
      .map(zio.aws.appflow.model.UnregisterConnectorResponse.wrap)
      .provideEnvironment(r)
    def listConnectors(
        request: ListConnectorsRequest
    ): IO[AwsError, zio.aws.appflow.model.ListConnectorsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appflow.model.ListConnectorsRequest,
        ListConnectorsResponse
      ]("listConnectors", api.listConnectors)(request.buildAwsValue())
        .map(zio.aws.appflow.model.ListConnectorsResponse.wrap)
        .provideEnvironment(r)
  }
  def stopFlow(
      request: StopFlowRequest
  ): ZIO[zio.aws.appflow.Appflow, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.stopFlow(request))
  def startFlow(request: StartFlowRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.StartFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startFlow(request))
  def updateFlow(request: UpdateFlowRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.UpdateFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFlow(request))
  def createConnectorProfile(request: CreateConnectorProfileRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.CreateConnectorProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnectorProfile(request))
  def registerConnector(request: RegisterConnectorRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.RegisterConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerConnector(request))
  def deleteFlow(request: DeleteFlowRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.DeleteFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFlow(request))
  def describeConnector(request: DescribeConnectorRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.DescribeConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnector(request))
  def listFlows(request: ListFlowsRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.ListFlowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFlows(request))
  def deleteConnectorProfile(request: DeleteConnectorProfileRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.DeleteConnectorProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnectorProfile(request))
  def describeFlowExecutionRecords(
      request: DescribeFlowExecutionRecordsRequest
  ): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFlowExecutionRecords(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeFlow(request: DescribeFlowRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.DescribeFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFlow(request))
  def listConnectorEntities(request: ListConnectorEntitiesRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.ListConnectorEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConnectorEntities(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateConnectorProfile(request: UpdateConnectorProfileRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.UpdateConnectorProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConnectorProfile(request))
  def describeConnectorProfiles(request: DescribeConnectorProfilesRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.DescribeConnectorProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnectorProfiles(request))
  def describeConnectors(request: DescribeConnectorsRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.DescribeConnectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnectors(request))
  def describeConnectorEntity(request: DescribeConnectorEntityRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.DescribeConnectorEntityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnectorEntity(request))
  def createFlow(request: CreateFlowRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.CreateFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFlow(request))
  def unregisterConnector(request: UnregisterConnectorRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.UnregisterConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.unregisterConnector(request))
  def listConnectors(request: ListConnectorsRequest): ZIO[
    zio.aws.appflow.Appflow,
    AwsError,
    zio.aws.appflow.model.ListConnectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConnectors(request))
}
