package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait AggregationType {
  def unwrap: software.amazon.awssdk.services.appflow.model.AggregationType
}
object AggregationType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.AggregationType
  ): zio.aws.appflow.model.AggregationType = value match {
    case software.amazon.awssdk.services.appflow.model.AggregationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.AggregationType.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.appflow.model.AggregationType.SINGLE_FILE =>
      val r = SingleFile
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.AggregationType =
      software.amazon.awssdk.services.appflow.model.AggregationType.UNKNOWN_TO_SDK_VERSION
  }
  case object None extends zio.aws.appflow.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.AggregationType =
      software.amazon.awssdk.services.appflow.model.AggregationType.NONE
  }
  case object SingleFile extends zio.aws.appflow.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.AggregationType =
      software.amazon.awssdk.services.appflow.model.AggregationType.SINGLE_FILE
  }
}
