package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.{SecretKey, ApiKey}
import scala.jdk.CollectionConverters._
final case class AmplitudeConnectorProfileCredentials(
    apiKey: ApiKey,
    secretKey: SecretKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.AmplitudeConnectorProfileCredentials = {
    import AmplitudeConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.AmplitudeConnectorProfileCredentials
      .builder()
      .apiKey(ApiKey.unwrap(apiKey): java.lang.String)
      .secretKey(SecretKey.unwrap(secretKey): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.AmplitudeConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.AmplitudeConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object AmplitudeConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.AmplitudeConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.AmplitudeConnectorProfileCredentials =
      zio.aws.appflow.model
        .AmplitudeConnectorProfileCredentials(apiKey, secretKey)
    def apiKey: ApiKey
    def secretKey: SecretKey
    def getApiKey: ZIO[Any, Nothing, ApiKey] = ZIO.succeed(apiKey)
    def getSecretKey: ZIO[Any, Nothing, SecretKey] = ZIO.succeed(secretKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.AmplitudeConnectorProfileCredentials
  ) extends zio.aws.appflow.model.AmplitudeConnectorProfileCredentials.ReadOnly {
    override val apiKey: ApiKey =
      zio.aws.appflow.model.primitives.ApiKey(impl.apiKey())
    override val secretKey: SecretKey =
      zio.aws.appflow.model.primitives.SecretKey(impl.secretKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.AmplitudeConnectorProfileCredentials
  ): zio.aws.appflow.model.AmplitudeConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
