package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AuthenticationConfig(
    isBasicAuthSupported: Optional[Boolean] = Optional.Absent,
    isApiKeyAuthSupported: Optional[Boolean] = Optional.Absent,
    isOAuth2Supported: Optional[Boolean] = Optional.Absent,
    isCustomAuthSupported: Optional[Boolean] = Optional.Absent,
    oAuth2Defaults: Optional[zio.aws.appflow.model.OAuth2Defaults] =
      Optional.Absent,
    customAuthConfigs: Optional[
      Iterable[zio.aws.appflow.model.CustomAuthConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.AuthenticationConfig = {
    import AuthenticationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.AuthenticationConfig
      .builder()
      .optionallyWith(
        isBasicAuthSupported.map(value => value: java.lang.Boolean)
      )(_.isBasicAuthSupported)
      .optionallyWith(
        isApiKeyAuthSupported.map(value => value: java.lang.Boolean)
      )(_.isApiKeyAuthSupported)
      .optionallyWith(isOAuth2Supported.map(value => value: java.lang.Boolean))(
        _.isOAuth2Supported
      )
      .optionallyWith(
        isCustomAuthSupported.map(value => value: java.lang.Boolean)
      )(_.isCustomAuthSupported)
      .optionallyWith(oAuth2Defaults.map(value => value.buildAwsValue()))(
        _.oAuth2Defaults
      )
      .optionallyWith(
        customAuthConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customAuthConfigs)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.AuthenticationConfig.ReadOnly =
    zio.aws.appflow.model.AuthenticationConfig.wrap(buildAwsValue())
}
object AuthenticationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.AuthenticationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.AuthenticationConfig =
      zio.aws.appflow.model.AuthenticationConfig(
        isBasicAuthSupported.map(value => value),
        isApiKeyAuthSupported.map(value => value),
        isOAuth2Supported.map(value => value),
        isCustomAuthSupported.map(value => value),
        oAuth2Defaults.map(value => value.asEditable),
        customAuthConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def isBasicAuthSupported: Optional[Boolean]
    def isApiKeyAuthSupported: Optional[Boolean]
    def isOAuth2Supported: Optional[Boolean]
    def isCustomAuthSupported: Optional[Boolean]
    def oAuth2Defaults: Optional[zio.aws.appflow.model.OAuth2Defaults.ReadOnly]
    def customAuthConfigs
        : Optional[List[zio.aws.appflow.model.CustomAuthConfig.ReadOnly]]
    def getIsBasicAuthSupported: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isBasicAuthSupported", isBasicAuthSupported)
    def getIsApiKeyAuthSupported: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isApiKeyAuthSupported", isApiKeyAuthSupported)
    def getIsOAuth2Supported: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isOAuth2Supported", isOAuth2Supported)
    def getIsCustomAuthSupported: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isCustomAuthSupported", isCustomAuthSupported)
    def getOAuth2Defaults
        : ZIO[Any, AwsError, zio.aws.appflow.model.OAuth2Defaults.ReadOnly] =
      AwsError.unwrapOptionField("oAuth2Defaults", oAuth2Defaults)
    def getCustomAuthConfigs: ZIO[Any, AwsError, List[
      zio.aws.appflow.model.CustomAuthConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("customAuthConfigs", customAuthConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.AuthenticationConfig
  ) extends zio.aws.appflow.model.AuthenticationConfig.ReadOnly {
    override val isBasicAuthSupported: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isBasicAuthSupported())
      .map(value => value: Boolean)
    override val isApiKeyAuthSupported: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isApiKeyAuthSupported())
        .map(value => value: Boolean)
    override val isOAuth2Supported: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isOAuth2Supported())
      .map(value => value: Boolean)
    override val isCustomAuthSupported: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isCustomAuthSupported())
        .map(value => value: Boolean)
    override val oAuth2Defaults
        : Optional[zio.aws.appflow.model.OAuth2Defaults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oAuth2Defaults())
        .map(value => zio.aws.appflow.model.OAuth2Defaults.wrap(value))
    override val customAuthConfigs
        : Optional[List[zio.aws.appflow.model.CustomAuthConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAuthConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.CustomAuthConfig.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.AuthenticationConfig
  ): zio.aws.appflow.model.AuthenticationConfig.ReadOnly = new Wrapper(impl)
}
