package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait AuthenticationType {
  def unwrap: software.amazon.awssdk.services.appflow.model.AuthenticationType
}
object AuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.AuthenticationType
  ): zio.aws.appflow.model.AuthenticationType = value match {
    case software.amazon.awssdk.services.appflow.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.AuthenticationType.OAUTH2 =>
      val r = OAUTH2
      r
    case software.amazon.awssdk.services.appflow.model.AuthenticationType.APIKEY =>
      val r = APIKEY
      r
    case software.amazon.awssdk.services.appflow.model.AuthenticationType.BASIC =>
      val r = BASIC
      r
    case software.amazon.awssdk.services.appflow.model.AuthenticationType.CUSTOM =>
      val r = CUSTOM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.AuthenticationType =
      software.amazon.awssdk.services.appflow.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object OAUTH2 extends zio.aws.appflow.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.AuthenticationType =
      software.amazon.awssdk.services.appflow.model.AuthenticationType.OAUTH2
  }
  case object APIKEY extends zio.aws.appflow.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.AuthenticationType =
      software.amazon.awssdk.services.appflow.model.AuthenticationType.APIKEY
  }
  case object BASIC extends zio.aws.appflow.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.AuthenticationType =
      software.amazon.awssdk.services.appflow.model.AuthenticationType.BASIC
  }
  case object CUSTOM extends zio.aws.appflow.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.AuthenticationType =
      software.amazon.awssdk.services.appflow.model.AuthenticationType.CUSTOM
  }
}
