package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ConnectorProfileConfig(
    connectorProfileProperties: zio.aws.appflow.model.ConnectorProfileProperties,
    connectorProfileCredentials: zio.aws.appflow.model.ConnectorProfileCredentials
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorProfileConfig = {
    import ConnectorProfileConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorProfileConfig
      .builder()
      .connectorProfileProperties(connectorProfileProperties.buildAwsValue())
      .connectorProfileCredentials(connectorProfileCredentials.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorProfileConfig.ReadOnly =
    zio.aws.appflow.model.ConnectorProfileConfig.wrap(buildAwsValue())
}
object ConnectorProfileConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorProfileConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorProfileConfig =
      zio.aws.appflow.model.ConnectorProfileConfig(
        connectorProfileProperties.asEditable,
        connectorProfileCredentials.asEditable
      )
    def connectorProfileProperties
        : zio.aws.appflow.model.ConnectorProfileProperties.ReadOnly
    def connectorProfileCredentials
        : zio.aws.appflow.model.ConnectorProfileCredentials.ReadOnly
    def getConnectorProfileProperties: ZIO[
      Any,
      Nothing,
      zio.aws.appflow.model.ConnectorProfileProperties.ReadOnly
    ] = ZIO.succeed(connectorProfileProperties)
    def getConnectorProfileCredentials: ZIO[
      Any,
      Nothing,
      zio.aws.appflow.model.ConnectorProfileCredentials.ReadOnly
    ] = ZIO.succeed(connectorProfileCredentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorProfileConfig
  ) extends zio.aws.appflow.model.ConnectorProfileConfig.ReadOnly {
    override val connectorProfileProperties
        : zio.aws.appflow.model.ConnectorProfileProperties.ReadOnly =
      zio.aws.appflow.model.ConnectorProfileProperties
        .wrap(impl.connectorProfileProperties())
    override val connectorProfileCredentials
        : zio.aws.appflow.model.ConnectorProfileCredentials.ReadOnly =
      zio.aws.appflow.model.ConnectorProfileCredentials
        .wrap(impl.connectorProfileCredentials())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorProfileConfig
  ): zio.aws.appflow.model.ConnectorProfileConfig.ReadOnly = new Wrapper(impl)
}
