package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectorProfileCredentials(
    amplitude: Optional[
      zio.aws.appflow.model.AmplitudeConnectorProfileCredentials
    ] = Optional.Absent,
    datadog: Optional[
      zio.aws.appflow.model.DatadogConnectorProfileCredentials
    ] = Optional.Absent,
    dynatrace: Optional[
      zio.aws.appflow.model.DynatraceConnectorProfileCredentials
    ] = Optional.Absent,
    googleAnalytics: Optional[
      zio.aws.appflow.model.GoogleAnalyticsConnectorProfileCredentials
    ] = Optional.Absent,
    honeycode: Optional[
      zio.aws.appflow.model.HoneycodeConnectorProfileCredentials
    ] = Optional.Absent,
    inforNexus: Optional[
      zio.aws.appflow.model.InforNexusConnectorProfileCredentials
    ] = Optional.Absent,
    marketo: Optional[
      zio.aws.appflow.model.MarketoConnectorProfileCredentials
    ] = Optional.Absent,
    redshift: Optional[
      zio.aws.appflow.model.RedshiftConnectorProfileCredentials
    ] = Optional.Absent,
    salesforce: Optional[
      zio.aws.appflow.model.SalesforceConnectorProfileCredentials
    ] = Optional.Absent,
    serviceNow: Optional[
      zio.aws.appflow.model.ServiceNowConnectorProfileCredentials
    ] = Optional.Absent,
    singular: Optional[
      zio.aws.appflow.model.SingularConnectorProfileCredentials
    ] = Optional.Absent,
    slack: Optional[zio.aws.appflow.model.SlackConnectorProfileCredentials] =
      Optional.Absent,
    snowflake: Optional[
      zio.aws.appflow.model.SnowflakeConnectorProfileCredentials
    ] = Optional.Absent,
    trendmicro: Optional[
      zio.aws.appflow.model.TrendmicroConnectorProfileCredentials
    ] = Optional.Absent,
    veeva: Optional[zio.aws.appflow.model.VeevaConnectorProfileCredentials] =
      Optional.Absent,
    zendesk: Optional[
      zio.aws.appflow.model.ZendeskConnectorProfileCredentials
    ] = Optional.Absent,
    sapoData: Optional[
      zio.aws.appflow.model.SAPODataConnectorProfileCredentials
    ] = Optional.Absent,
    customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorProfileCredentials
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorProfileCredentials = {
    import ConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorProfileCredentials
      .builder()
      .optionallyWith(amplitude.map(value => value.buildAwsValue()))(
        _.amplitude
      )
      .optionallyWith(datadog.map(value => value.buildAwsValue()))(_.datadog)
      .optionallyWith(dynatrace.map(value => value.buildAwsValue()))(
        _.dynatrace
      )
      .optionallyWith(googleAnalytics.map(value => value.buildAwsValue()))(
        _.googleAnalytics
      )
      .optionallyWith(honeycode.map(value => value.buildAwsValue()))(
        _.honeycode
      )
      .optionallyWith(inforNexus.map(value => value.buildAwsValue()))(
        _.inforNexus
      )
      .optionallyWith(marketo.map(value => value.buildAwsValue()))(_.marketo)
      .optionallyWith(redshift.map(value => value.buildAwsValue()))(_.redshift)
      .optionallyWith(salesforce.map(value => value.buildAwsValue()))(
        _.salesforce
      )
      .optionallyWith(serviceNow.map(value => value.buildAwsValue()))(
        _.serviceNow
      )
      .optionallyWith(singular.map(value => value.buildAwsValue()))(_.singular)
      .optionallyWith(slack.map(value => value.buildAwsValue()))(_.slack)
      .optionallyWith(snowflake.map(value => value.buildAwsValue()))(
        _.snowflake
      )
      .optionallyWith(trendmicro.map(value => value.buildAwsValue()))(
        _.trendmicro
      )
      .optionallyWith(veeva.map(value => value.buildAwsValue()))(_.veeva)
      .optionallyWith(zendesk.map(value => value.buildAwsValue()))(_.zendesk)
      .optionallyWith(sapoData.map(value => value.buildAwsValue()))(_.sapoData)
      .optionallyWith(customConnector.map(value => value.buildAwsValue()))(
        _.customConnector
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.ConnectorProfileCredentials.wrap(buildAwsValue())
}
object ConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorProfileCredentials =
      zio.aws.appflow.model.ConnectorProfileCredentials(
        amplitude.map(value => value.asEditable),
        datadog.map(value => value.asEditable),
        dynatrace.map(value => value.asEditable),
        googleAnalytics.map(value => value.asEditable),
        honeycode.map(value => value.asEditable),
        inforNexus.map(value => value.asEditable),
        marketo.map(value => value.asEditable),
        redshift.map(value => value.asEditable),
        salesforce.map(value => value.asEditable),
        serviceNow.map(value => value.asEditable),
        singular.map(value => value.asEditable),
        slack.map(value => value.asEditable),
        snowflake.map(value => value.asEditable),
        trendmicro.map(value => value.asEditable),
        veeva.map(value => value.asEditable),
        zendesk.map(value => value.asEditable),
        sapoData.map(value => value.asEditable),
        customConnector.map(value => value.asEditable)
      )
    def amplitude: Optional[
      zio.aws.appflow.model.AmplitudeConnectorProfileCredentials.ReadOnly
    ]
    def datadog: Optional[
      zio.aws.appflow.model.DatadogConnectorProfileCredentials.ReadOnly
    ]
    def dynatrace: Optional[
      zio.aws.appflow.model.DynatraceConnectorProfileCredentials.ReadOnly
    ]
    def googleAnalytics: Optional[
      zio.aws.appflow.model.GoogleAnalyticsConnectorProfileCredentials.ReadOnly
    ]
    def honeycode: Optional[
      zio.aws.appflow.model.HoneycodeConnectorProfileCredentials.ReadOnly
    ]
    def inforNexus: Optional[
      zio.aws.appflow.model.InforNexusConnectorProfileCredentials.ReadOnly
    ]
    def marketo: Optional[
      zio.aws.appflow.model.MarketoConnectorProfileCredentials.ReadOnly
    ]
    def redshift: Optional[
      zio.aws.appflow.model.RedshiftConnectorProfileCredentials.ReadOnly
    ]
    def salesforce: Optional[
      zio.aws.appflow.model.SalesforceConnectorProfileCredentials.ReadOnly
    ]
    def serviceNow: Optional[
      zio.aws.appflow.model.ServiceNowConnectorProfileCredentials.ReadOnly
    ]
    def singular: Optional[
      zio.aws.appflow.model.SingularConnectorProfileCredentials.ReadOnly
    ]
    def slack: Optional[
      zio.aws.appflow.model.SlackConnectorProfileCredentials.ReadOnly
    ]
    def snowflake: Optional[
      zio.aws.appflow.model.SnowflakeConnectorProfileCredentials.ReadOnly
    ]
    def trendmicro: Optional[
      zio.aws.appflow.model.TrendmicroConnectorProfileCredentials.ReadOnly
    ]
    def veeva: Optional[
      zio.aws.appflow.model.VeevaConnectorProfileCredentials.ReadOnly
    ]
    def zendesk: Optional[
      zio.aws.appflow.model.ZendeskConnectorProfileCredentials.ReadOnly
    ]
    def sapoData: Optional[
      zio.aws.appflow.model.SAPODataConnectorProfileCredentials.ReadOnly
    ]
    def customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorProfileCredentials.ReadOnly
    ]
    def getAmplitude: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.AmplitudeConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("amplitude", amplitude)
    def getDatadog: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.DatadogConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("datadog", datadog)
    def getDynatrace: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.DynatraceConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("dynatrace", dynatrace)
    def getGoogleAnalytics: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.GoogleAnalyticsConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("googleAnalytics", googleAnalytics)
    def getHoneycode: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.HoneycodeConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("honeycode", honeycode)
    def getInforNexus: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.InforNexusConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("inforNexus", inforNexus)
    def getMarketo: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.MarketoConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("marketo", marketo)
    def getRedshift: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.RedshiftConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("redshift", redshift)
    def getSalesforce: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SalesforceConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("salesforce", salesforce)
    def getServiceNow: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ServiceNowConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("serviceNow", serviceNow)
    def getSingular: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SingularConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("singular", singular)
    def getSlack: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SlackConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("slack", slack)
    def getSnowflake: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SnowflakeConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("snowflake", snowflake)
    def getTrendmicro: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.TrendmicroConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("trendmicro", trendmicro)
    def getVeeva: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.VeevaConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("veeva", veeva)
    def getZendesk: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ZendeskConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("zendesk", zendesk)
    def getSapoData: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SAPODataConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("sapoData", sapoData)
    def getCustomConnector: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.CustomConnectorProfileCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("customConnector", customConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorProfileCredentials
  ) extends zio.aws.appflow.model.ConnectorProfileCredentials.ReadOnly {
    override val amplitude: Optional[
      zio.aws.appflow.model.AmplitudeConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.amplitude())
      .map(value =>
        zio.aws.appflow.model.AmplitudeConnectorProfileCredentials.wrap(value)
      )
    override val datadog: Optional[
      zio.aws.appflow.model.DatadogConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.datadog())
      .map(value =>
        zio.aws.appflow.model.DatadogConnectorProfileCredentials.wrap(value)
      )
    override val dynatrace: Optional[
      zio.aws.appflow.model.DynatraceConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dynatrace())
      .map(value =>
        zio.aws.appflow.model.DynatraceConnectorProfileCredentials.wrap(value)
      )
    override val googleAnalytics: Optional[
      zio.aws.appflow.model.GoogleAnalyticsConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.googleAnalytics())
      .map(value =>
        zio.aws.appflow.model.GoogleAnalyticsConnectorProfileCredentials
          .wrap(value)
      )
    override val honeycode: Optional[
      zio.aws.appflow.model.HoneycodeConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.honeycode())
      .map(value =>
        zio.aws.appflow.model.HoneycodeConnectorProfileCredentials.wrap(value)
      )
    override val inforNexus: Optional[
      zio.aws.appflow.model.InforNexusConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inforNexus())
      .map(value =>
        zio.aws.appflow.model.InforNexusConnectorProfileCredentials.wrap(value)
      )
    override val marketo: Optional[
      zio.aws.appflow.model.MarketoConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.marketo())
      .map(value =>
        zio.aws.appflow.model.MarketoConnectorProfileCredentials.wrap(value)
      )
    override val redshift: Optional[
      zio.aws.appflow.model.RedshiftConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.redshift())
      .map(value =>
        zio.aws.appflow.model.RedshiftConnectorProfileCredentials.wrap(value)
      )
    override val salesforce: Optional[
      zio.aws.appflow.model.SalesforceConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.salesforce())
      .map(value =>
        zio.aws.appflow.model.SalesforceConnectorProfileCredentials.wrap(value)
      )
    override val serviceNow: Optional[
      zio.aws.appflow.model.ServiceNowConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceNow())
      .map(value =>
        zio.aws.appflow.model.ServiceNowConnectorProfileCredentials.wrap(value)
      )
    override val singular: Optional[
      zio.aws.appflow.model.SingularConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.singular())
      .map(value =>
        zio.aws.appflow.model.SingularConnectorProfileCredentials.wrap(value)
      )
    override val slack: Optional[
      zio.aws.appflow.model.SlackConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.slack())
      .map(value =>
        zio.aws.appflow.model.SlackConnectorProfileCredentials.wrap(value)
      )
    override val snowflake: Optional[
      zio.aws.appflow.model.SnowflakeConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.snowflake())
      .map(value =>
        zio.aws.appflow.model.SnowflakeConnectorProfileCredentials.wrap(value)
      )
    override val trendmicro: Optional[
      zio.aws.appflow.model.TrendmicroConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trendmicro())
      .map(value =>
        zio.aws.appflow.model.TrendmicroConnectorProfileCredentials.wrap(value)
      )
    override val veeva: Optional[
      zio.aws.appflow.model.VeevaConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.veeva())
      .map(value =>
        zio.aws.appflow.model.VeevaConnectorProfileCredentials.wrap(value)
      )
    override val zendesk: Optional[
      zio.aws.appflow.model.ZendeskConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.zendesk())
      .map(value =>
        zio.aws.appflow.model.ZendeskConnectorProfileCredentials.wrap(value)
      )
    override val sapoData: Optional[
      zio.aws.appflow.model.SAPODataConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sapoData())
      .map(value =>
        zio.aws.appflow.model.SAPODataConnectorProfileCredentials.wrap(value)
      )
    override val customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorProfileCredentials.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customConnector())
      .map(value =>
        zio.aws.appflow.model.CustomConnectorProfileCredentials.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorProfileCredentials
  ): zio.aws.appflow.model.ConnectorProfileCredentials.ReadOnly = new Wrapper(
    impl
  )
}
