package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectorProfileProperties(
    amplitude: Optional[
      zio.aws.appflow.model.AmplitudeConnectorProfileProperties
    ] = Optional.Absent,
    datadog: Optional[zio.aws.appflow.model.DatadogConnectorProfileProperties] =
      Optional.Absent,
    dynatrace: Optional[
      zio.aws.appflow.model.DynatraceConnectorProfileProperties
    ] = Optional.Absent,
    googleAnalytics: Optional[
      zio.aws.appflow.model.GoogleAnalyticsConnectorProfileProperties
    ] = Optional.Absent,
    honeycode: Optional[
      zio.aws.appflow.model.HoneycodeConnectorProfileProperties
    ] = Optional.Absent,
    inforNexus: Optional[
      zio.aws.appflow.model.InforNexusConnectorProfileProperties
    ] = Optional.Absent,
    marketo: Optional[zio.aws.appflow.model.MarketoConnectorProfileProperties] =
      Optional.Absent,
    redshift: Optional[
      zio.aws.appflow.model.RedshiftConnectorProfileProperties
    ] = Optional.Absent,
    salesforce: Optional[
      zio.aws.appflow.model.SalesforceConnectorProfileProperties
    ] = Optional.Absent,
    serviceNow: Optional[
      zio.aws.appflow.model.ServiceNowConnectorProfileProperties
    ] = Optional.Absent,
    singular: Optional[
      zio.aws.appflow.model.SingularConnectorProfileProperties
    ] = Optional.Absent,
    slack: Optional[zio.aws.appflow.model.SlackConnectorProfileProperties] =
      Optional.Absent,
    snowflake: Optional[
      zio.aws.appflow.model.SnowflakeConnectorProfileProperties
    ] = Optional.Absent,
    trendmicro: Optional[
      zio.aws.appflow.model.TrendmicroConnectorProfileProperties
    ] = Optional.Absent,
    veeva: Optional[zio.aws.appflow.model.VeevaConnectorProfileProperties] =
      Optional.Absent,
    zendesk: Optional[zio.aws.appflow.model.ZendeskConnectorProfileProperties] =
      Optional.Absent,
    sapoData: Optional[
      zio.aws.appflow.model.SAPODataConnectorProfileProperties
    ] = Optional.Absent,
    customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorProfileProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorProfileProperties = {
    import ConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorProfileProperties
      .builder()
      .optionallyWith(amplitude.map(value => value.buildAwsValue()))(
        _.amplitude
      )
      .optionallyWith(datadog.map(value => value.buildAwsValue()))(_.datadog)
      .optionallyWith(dynatrace.map(value => value.buildAwsValue()))(
        _.dynatrace
      )
      .optionallyWith(googleAnalytics.map(value => value.buildAwsValue()))(
        _.googleAnalytics
      )
      .optionallyWith(honeycode.map(value => value.buildAwsValue()))(
        _.honeycode
      )
      .optionallyWith(inforNexus.map(value => value.buildAwsValue()))(
        _.inforNexus
      )
      .optionallyWith(marketo.map(value => value.buildAwsValue()))(_.marketo)
      .optionallyWith(redshift.map(value => value.buildAwsValue()))(_.redshift)
      .optionallyWith(salesforce.map(value => value.buildAwsValue()))(
        _.salesforce
      )
      .optionallyWith(serviceNow.map(value => value.buildAwsValue()))(
        _.serviceNow
      )
      .optionallyWith(singular.map(value => value.buildAwsValue()))(_.singular)
      .optionallyWith(slack.map(value => value.buildAwsValue()))(_.slack)
      .optionallyWith(snowflake.map(value => value.buildAwsValue()))(
        _.snowflake
      )
      .optionallyWith(trendmicro.map(value => value.buildAwsValue()))(
        _.trendmicro
      )
      .optionallyWith(veeva.map(value => value.buildAwsValue()))(_.veeva)
      .optionallyWith(zendesk.map(value => value.buildAwsValue()))(_.zendesk)
      .optionallyWith(sapoData.map(value => value.buildAwsValue()))(_.sapoData)
      .optionallyWith(customConnector.map(value => value.buildAwsValue()))(
        _.customConnector
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.ConnectorProfileProperties.wrap(buildAwsValue())
}
object ConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorProfileProperties =
      zio.aws.appflow.model.ConnectorProfileProperties(
        amplitude.map(value => value.asEditable),
        datadog.map(value => value.asEditable),
        dynatrace.map(value => value.asEditable),
        googleAnalytics.map(value => value.asEditable),
        honeycode.map(value => value.asEditable),
        inforNexus.map(value => value.asEditable),
        marketo.map(value => value.asEditable),
        redshift.map(value => value.asEditable),
        salesforce.map(value => value.asEditable),
        serviceNow.map(value => value.asEditable),
        singular.map(value => value.asEditable),
        slack.map(value => value.asEditable),
        snowflake.map(value => value.asEditable),
        trendmicro.map(value => value.asEditable),
        veeva.map(value => value.asEditable),
        zendesk.map(value => value.asEditable),
        sapoData.map(value => value.asEditable),
        customConnector.map(value => value.asEditable)
      )
    def amplitude: Optional[
      zio.aws.appflow.model.AmplitudeConnectorProfileProperties.ReadOnly
    ]
    def datadog: Optional[
      zio.aws.appflow.model.DatadogConnectorProfileProperties.ReadOnly
    ]
    def dynatrace: Optional[
      zio.aws.appflow.model.DynatraceConnectorProfileProperties.ReadOnly
    ]
    def googleAnalytics: Optional[
      zio.aws.appflow.model.GoogleAnalyticsConnectorProfileProperties.ReadOnly
    ]
    def honeycode: Optional[
      zio.aws.appflow.model.HoneycodeConnectorProfileProperties.ReadOnly
    ]
    def inforNexus: Optional[
      zio.aws.appflow.model.InforNexusConnectorProfileProperties.ReadOnly
    ]
    def marketo: Optional[
      zio.aws.appflow.model.MarketoConnectorProfileProperties.ReadOnly
    ]
    def redshift: Optional[
      zio.aws.appflow.model.RedshiftConnectorProfileProperties.ReadOnly
    ]
    def salesforce: Optional[
      zio.aws.appflow.model.SalesforceConnectorProfileProperties.ReadOnly
    ]
    def serviceNow: Optional[
      zio.aws.appflow.model.ServiceNowConnectorProfileProperties.ReadOnly
    ]
    def singular: Optional[
      zio.aws.appflow.model.SingularConnectorProfileProperties.ReadOnly
    ]
    def slack: Optional[
      zio.aws.appflow.model.SlackConnectorProfileProperties.ReadOnly
    ]
    def snowflake: Optional[
      zio.aws.appflow.model.SnowflakeConnectorProfileProperties.ReadOnly
    ]
    def trendmicro: Optional[
      zio.aws.appflow.model.TrendmicroConnectorProfileProperties.ReadOnly
    ]
    def veeva: Optional[
      zio.aws.appflow.model.VeevaConnectorProfileProperties.ReadOnly
    ]
    def zendesk: Optional[
      zio.aws.appflow.model.ZendeskConnectorProfileProperties.ReadOnly
    ]
    def sapoData: Optional[
      zio.aws.appflow.model.SAPODataConnectorProfileProperties.ReadOnly
    ]
    def customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorProfileProperties.ReadOnly
    ]
    def getAmplitude: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.AmplitudeConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("amplitude", amplitude)
    def getDatadog: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.DatadogConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("datadog", datadog)
    def getDynatrace: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.DynatraceConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("dynatrace", dynatrace)
    def getGoogleAnalytics: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.GoogleAnalyticsConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("googleAnalytics", googleAnalytics)
    def getHoneycode: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.HoneycodeConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("honeycode", honeycode)
    def getInforNexus: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.InforNexusConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("inforNexus", inforNexus)
    def getMarketo: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.MarketoConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("marketo", marketo)
    def getRedshift: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.RedshiftConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("redshift", redshift)
    def getSalesforce: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SalesforceConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("salesforce", salesforce)
    def getServiceNow: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ServiceNowConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("serviceNow", serviceNow)
    def getSingular: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SingularConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("singular", singular)
    def getSlack: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SlackConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("slack", slack)
    def getSnowflake: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SnowflakeConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("snowflake", snowflake)
    def getTrendmicro: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.TrendmicroConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("trendmicro", trendmicro)
    def getVeeva: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.VeevaConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("veeva", veeva)
    def getZendesk: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ZendeskConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("zendesk", zendesk)
    def getSapoData: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SAPODataConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("sapoData", sapoData)
    def getCustomConnector: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.CustomConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField("customConnector", customConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorProfileProperties
  ) extends zio.aws.appflow.model.ConnectorProfileProperties.ReadOnly {
    override val amplitude: Optional[
      zio.aws.appflow.model.AmplitudeConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.amplitude())
      .map(value =>
        zio.aws.appflow.model.AmplitudeConnectorProfileProperties.wrap(value)
      )
    override val datadog: Optional[
      zio.aws.appflow.model.DatadogConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.datadog())
      .map(value =>
        zio.aws.appflow.model.DatadogConnectorProfileProperties.wrap(value)
      )
    override val dynatrace: Optional[
      zio.aws.appflow.model.DynatraceConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dynatrace())
      .map(value =>
        zio.aws.appflow.model.DynatraceConnectorProfileProperties.wrap(value)
      )
    override val googleAnalytics: Optional[
      zio.aws.appflow.model.GoogleAnalyticsConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.googleAnalytics())
      .map(value =>
        zio.aws.appflow.model.GoogleAnalyticsConnectorProfileProperties
          .wrap(value)
      )
    override val honeycode: Optional[
      zio.aws.appflow.model.HoneycodeConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.honeycode())
      .map(value =>
        zio.aws.appflow.model.HoneycodeConnectorProfileProperties.wrap(value)
      )
    override val inforNexus: Optional[
      zio.aws.appflow.model.InforNexusConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inforNexus())
      .map(value =>
        zio.aws.appflow.model.InforNexusConnectorProfileProperties.wrap(value)
      )
    override val marketo: Optional[
      zio.aws.appflow.model.MarketoConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.marketo())
      .map(value =>
        zio.aws.appflow.model.MarketoConnectorProfileProperties.wrap(value)
      )
    override val redshift: Optional[
      zio.aws.appflow.model.RedshiftConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.redshift())
      .map(value =>
        zio.aws.appflow.model.RedshiftConnectorProfileProperties.wrap(value)
      )
    override val salesforce: Optional[
      zio.aws.appflow.model.SalesforceConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.salesforce())
      .map(value =>
        zio.aws.appflow.model.SalesforceConnectorProfileProperties.wrap(value)
      )
    override val serviceNow: Optional[
      zio.aws.appflow.model.ServiceNowConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceNow())
      .map(value =>
        zio.aws.appflow.model.ServiceNowConnectorProfileProperties.wrap(value)
      )
    override val singular: Optional[
      zio.aws.appflow.model.SingularConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.singular())
      .map(value =>
        zio.aws.appflow.model.SingularConnectorProfileProperties.wrap(value)
      )
    override val slack: Optional[
      zio.aws.appflow.model.SlackConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.slack())
      .map(value =>
        zio.aws.appflow.model.SlackConnectorProfileProperties.wrap(value)
      )
    override val snowflake: Optional[
      zio.aws.appflow.model.SnowflakeConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.snowflake())
      .map(value =>
        zio.aws.appflow.model.SnowflakeConnectorProfileProperties.wrap(value)
      )
    override val trendmicro: Optional[
      zio.aws.appflow.model.TrendmicroConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trendmicro())
      .map(value =>
        zio.aws.appflow.model.TrendmicroConnectorProfileProperties.wrap(value)
      )
    override val veeva: Optional[
      zio.aws.appflow.model.VeevaConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.veeva())
      .map(value =>
        zio.aws.appflow.model.VeevaConnectorProfileProperties.wrap(value)
      )
    override val zendesk: Optional[
      zio.aws.appflow.model.ZendeskConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.zendesk())
      .map(value =>
        zio.aws.appflow.model.ZendeskConnectorProfileProperties.wrap(value)
      )
    override val sapoData: Optional[
      zio.aws.appflow.model.SAPODataConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sapoData())
      .map(value =>
        zio.aws.appflow.model.SAPODataConnectorProfileProperties.wrap(value)
      )
    override val customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorProfileProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customConnector())
      .map(value =>
        zio.aws.appflow.model.CustomConnectorProfileProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorProfileProperties
  ): zio.aws.appflow.model.ConnectorProfileProperties.ReadOnly = new Wrapper(
    impl
  )
}
