package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectorProvisioningConfig(
    lambda: Optional[zio.aws.appflow.model.LambdaConnectorProvisioningConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorProvisioningConfig = {
    import ConnectorProvisioningConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorProvisioningConfig
      .builder()
      .optionallyWith(lambda.map(value => value.buildAwsValue()))(_.lambda)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorProvisioningConfig.ReadOnly =
    zio.aws.appflow.model.ConnectorProvisioningConfig.wrap(buildAwsValue())
}
object ConnectorProvisioningConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorProvisioningConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorProvisioningConfig =
      zio.aws.appflow.model
        .ConnectorProvisioningConfig(lambda.map(value => value.asEditable))
    def lambda: Optional[
      zio.aws.appflow.model.LambdaConnectorProvisioningConfig.ReadOnly
    ]
    def getLambda: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.LambdaConnectorProvisioningConfig.ReadOnly
    ] = AwsError.unwrapOptionField("lambda", lambda)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorProvisioningConfig
  ) extends zio.aws.appflow.model.ConnectorProvisioningConfig.ReadOnly {
    override val lambda: Optional[
      zio.aws.appflow.model.LambdaConnectorProvisioningConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambda())
      .map(value =>
        zio.aws.appflow.model.LambdaConnectorProvisioningConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorProvisioningConfig
  ): zio.aws.appflow.model.ConnectorProvisioningConfig.ReadOnly = new Wrapper(
    impl
  )
}
