package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait ConnectorProvisioningType {
  def unwrap
      : software.amazon.awssdk.services.appflow.model.ConnectorProvisioningType
}
object ConnectorProvisioningType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.ConnectorProvisioningType
  ): zio.aws.appflow.model.ConnectorProvisioningType = value match {
    case software.amazon.awssdk.services.appflow.model.ConnectorProvisioningType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorProvisioningType.LAMBDA =>
      val r = LAMBDA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.ConnectorProvisioningType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorProvisioningType =
      software.amazon.awssdk.services.appflow.model.ConnectorProvisioningType.UNKNOWN_TO_SDK_VERSION
  }
  case object LAMBDA extends zio.aws.appflow.model.ConnectorProvisioningType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorProvisioningType =
      software.amazon.awssdk.services.appflow.model.ConnectorProvisioningType.LAMBDA
  }
}
