package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  Key,
  ConnectorRuntimeSettingDataType,
  Label,
  Description,
  ConnectorRuntimeSettingScope,
  ConnectorSuppliedValue
}
import scala.jdk.CollectionConverters._
final case class ConnectorRuntimeSetting(
    key: Optional[Key] = Optional.Absent,
    dataType: Optional[ConnectorRuntimeSettingDataType] = Optional.Absent,
    isRequired: Optional[Boolean] = Optional.Absent,
    label: Optional[Label] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    scope: Optional[ConnectorRuntimeSettingScope] = Optional.Absent,
    connectorSuppliedValueOptions: Optional[Iterable[ConnectorSuppliedValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorRuntimeSetting = {
    import ConnectorRuntimeSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorRuntimeSetting
      .builder()
      .optionallyWith(key.map(value => Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        dataType.map(value =>
          ConnectorRuntimeSettingDataType.unwrap(value): java.lang.String
        )
      )(_.dataType)
      .optionallyWith(isRequired.map(value => value: java.lang.Boolean))(
        _.isRequired
      )
      .optionallyWith(
        label.map(value => Label.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        scope.map(value =>
          ConnectorRuntimeSettingScope.unwrap(value): java.lang.String
        )
      )(_.scope)
      .optionallyWith(
        connectorSuppliedValueOptions.map(value =>
          value.map { item =>
            ConnectorSuppliedValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.connectorSuppliedValueOptions)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorRuntimeSetting.ReadOnly =
    zio.aws.appflow.model.ConnectorRuntimeSetting.wrap(buildAwsValue())
}
object ConnectorRuntimeSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorRuntimeSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorRuntimeSetting =
      zio.aws.appflow.model.ConnectorRuntimeSetting(
        key.map(value => value),
        dataType.map(value => value),
        isRequired.map(value => value),
        label.map(value => value),
        description.map(value => value),
        scope.map(value => value),
        connectorSuppliedValueOptions.map(value => value)
      )
    def key: Optional[Key]
    def dataType: Optional[ConnectorRuntimeSettingDataType]
    def isRequired: Optional[Boolean]
    def label: Optional[Label]
    def description: Optional[Description]
    def scope: Optional[ConnectorRuntimeSettingScope]
    def connectorSuppliedValueOptions: Optional[List[ConnectorSuppliedValue]]
    def getKey: ZIO[Any, AwsError, Key] = AwsError.unwrapOptionField("key", key)
    def getDataType: ZIO[Any, AwsError, ConnectorRuntimeSettingDataType] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getIsRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRequired", isRequired)
    def getLabel: ZIO[Any, AwsError, Label] =
      AwsError.unwrapOptionField("label", label)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getScope: ZIO[Any, AwsError, ConnectorRuntimeSettingScope] =
      AwsError.unwrapOptionField("scope", scope)
    def getConnectorSuppliedValueOptions
        : ZIO[Any, AwsError, List[ConnectorSuppliedValue]] =
      AwsError.unwrapOptionField(
        "connectorSuppliedValueOptions",
        connectorSuppliedValueOptions
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorRuntimeSetting
  ) extends zio.aws.appflow.model.ConnectorRuntimeSetting.ReadOnly {
    override val key: Optional[Key] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.appflow.model.primitives.Key(value))
    override val dataType: Optional[ConnectorRuntimeSettingDataType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataType())
        .map(value =>
          zio.aws.appflow.model.primitives
            .ConnectorRuntimeSettingDataType(value)
        )
    override val isRequired: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isRequired())
      .map(value => value: Boolean)
    override val label: Optional[Label] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.appflow.model.primitives.Label(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appflow.model.primitives.Description(value))
    override val scope: Optional[ConnectorRuntimeSettingScope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value =>
          zio.aws.appflow.model.primitives.ConnectorRuntimeSettingScope(value)
        )
    override val connectorSuppliedValueOptions
        : Optional[List[ConnectorSuppliedValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorSuppliedValueOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appflow.model.primitives.ConnectorSuppliedValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorRuntimeSetting
  ): zio.aws.appflow.model.ConnectorRuntimeSetting.ReadOnly = new Wrapper(impl)
}
