package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait ConnectorType {
  def unwrap: software.amazon.awssdk.services.appflow.model.ConnectorType
}
object ConnectorType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.ConnectorType
  ): zio.aws.appflow.model.ConnectorType = value match {
    case software.amazon.awssdk.services.appflow.model.ConnectorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.SALESFORCE =>
      val r = Salesforce
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.SINGULAR =>
      val r = Singular
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.SLACK =>
      val r = Slack
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.REDSHIFT =>
      val r = Redshift
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.S3 =>
      val r = S3
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.MARKETO =>
      val r = Marketo
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.GOOGLEANALYTICS =>
      val r = Googleanalytics
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.ZENDESK =>
      val r = Zendesk
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.SERVICENOW =>
      val r = Servicenow
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.DATADOG =>
      val r = Datadog
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.TRENDMICRO =>
      val r = Trendmicro
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.SNOWFLAKE =>
      val r = Snowflake
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.DYNATRACE =>
      val r = Dynatrace
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.INFORNEXUS =>
      val r = Infornexus
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.AMPLITUDE =>
      val r = Amplitude
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.VEEVA =>
      val r = Veeva
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.EVENT_BRIDGE =>
      val r = EventBridge
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.LOOKOUT_METRICS =>
      val r = LookoutMetrics
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.UPSOLVER =>
      val r = Upsolver
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.HONEYCODE =>
      val r = Honeycode
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.CUSTOMER_PROFILES =>
      val r = CustomerProfiles
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.SAPO_DATA =>
      val r = SAPOData
      r
    case software.amazon.awssdk.services.appflow.model.ConnectorType.CUSTOM_CONNECTOR =>
      val r = CustomConnector
      r
  }
  case object unknownToSdkVersion extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.UNKNOWN_TO_SDK_VERSION
  }
  case object Salesforce extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.SALESFORCE
  }
  case object Singular extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.SINGULAR
  }
  case object Slack extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.SLACK
  }
  case object Redshift extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.REDSHIFT
  }
  case object S3 extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.S3
  }
  case object Marketo extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.MARKETO
  }
  case object Googleanalytics extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.GOOGLEANALYTICS
  }
  case object Zendesk extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.ZENDESK
  }
  case object Servicenow extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.SERVICENOW
  }
  case object Datadog extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.DATADOG
  }
  case object Trendmicro extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.TRENDMICRO
  }
  case object Snowflake extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.SNOWFLAKE
  }
  case object Dynatrace extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.DYNATRACE
  }
  case object Infornexus extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.INFORNEXUS
  }
  case object Amplitude extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.AMPLITUDE
  }
  case object Veeva extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.VEEVA
  }
  case object EventBridge extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.EVENT_BRIDGE
  }
  case object LookoutMetrics extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.LOOKOUT_METRICS
  }
  case object Upsolver extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.UPSOLVER
  }
  case object Honeycode extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.HONEYCODE
  }
  case object CustomerProfiles extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.CUSTOMER_PROFILES
  }
  case object SAPOData extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.SAPO_DATA
  }
  case object CustomConnector extends zio.aws.appflow.model.ConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectorType =
      software.amazon.awssdk.services.appflow.model.ConnectorType.CUSTOM_CONNECTOR
  }
}
