package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  ConnectorLabel,
  KMSArn,
  ConnectorProfileName
}
import scala.jdk.CollectionConverters._
final case class CreateConnectorProfileRequest(
    connectorProfileName: ConnectorProfileName,
    kmsArn: Optional[KMSArn] = Optional.Absent,
    connectorType: zio.aws.appflow.model.ConnectorType,
    connectorLabel: Optional[ConnectorLabel] = Optional.Absent,
    connectionMode: zio.aws.appflow.model.ConnectionMode,
    connectorProfileConfig: zio.aws.appflow.model.ConnectorProfileConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.CreateConnectorProfileRequest = {
    import CreateConnectorProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.CreateConnectorProfileRequest
      .builder()
      .connectorProfileName(
        ConnectorProfileName.unwrap(connectorProfileName): java.lang.String
      )
      .optionallyWith(
        kmsArn.map(value => KMSArn.unwrap(value): java.lang.String)
      )(_.kmsArn)
      .connectorType(connectorType.unwrap)
      .optionallyWith(
        connectorLabel.map(value =>
          ConnectorLabel.unwrap(value): java.lang.String
        )
      )(_.connectorLabel)
      .connectionMode(connectionMode.unwrap)
      .connectorProfileConfig(connectorProfileConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.CreateConnectorProfileRequest.ReadOnly =
    zio.aws.appflow.model.CreateConnectorProfileRequest.wrap(buildAwsValue())
}
object CreateConnectorProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.CreateConnectorProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.CreateConnectorProfileRequest =
      zio.aws.appflow.model.CreateConnectorProfileRequest(
        connectorProfileName,
        kmsArn.map(value => value),
        connectorType,
        connectorLabel.map(value => value),
        connectionMode,
        connectorProfileConfig.asEditable
      )
    def connectorProfileName: ConnectorProfileName
    def kmsArn: Optional[KMSArn]
    def connectorType: zio.aws.appflow.model.ConnectorType
    def connectorLabel: Optional[ConnectorLabel]
    def connectionMode: zio.aws.appflow.model.ConnectionMode
    def connectorProfileConfig
        : zio.aws.appflow.model.ConnectorProfileConfig.ReadOnly
    def getConnectorProfileName: ZIO[Any, Nothing, ConnectorProfileName] =
      ZIO.succeed(connectorProfileName)
    def getKmsArn: ZIO[Any, AwsError, KMSArn] =
      AwsError.unwrapOptionField("kmsArn", kmsArn)
    def getConnectorType
        : ZIO[Any, Nothing, zio.aws.appflow.model.ConnectorType] =
      ZIO.succeed(connectorType)
    def getConnectorLabel: ZIO[Any, AwsError, ConnectorLabel] =
      AwsError.unwrapOptionField("connectorLabel", connectorLabel)
    def getConnectionMode
        : ZIO[Any, Nothing, zio.aws.appflow.model.ConnectionMode] =
      ZIO.succeed(connectionMode)
    def getConnectorProfileConfig: ZIO[
      Any,
      Nothing,
      zio.aws.appflow.model.ConnectorProfileConfig.ReadOnly
    ] = ZIO.succeed(connectorProfileConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.CreateConnectorProfileRequest
  ) extends zio.aws.appflow.model.CreateConnectorProfileRequest.ReadOnly {
    override val connectorProfileName: ConnectorProfileName =
      zio.aws.appflow.model.primitives
        .ConnectorProfileName(impl.connectorProfileName())
    override val kmsArn: Optional[KMSArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsArn())
      .map(value => zio.aws.appflow.model.primitives.KMSArn(value))
    override val connectorType: zio.aws.appflow.model.ConnectorType =
      zio.aws.appflow.model.ConnectorType.wrap(impl.connectorType())
    override val connectorLabel: Optional[ConnectorLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorLabel())
        .map(value => zio.aws.appflow.model.primitives.ConnectorLabel(value))
    override val connectionMode: zio.aws.appflow.model.ConnectionMode =
      zio.aws.appflow.model.ConnectionMode.wrap(impl.connectionMode())
    override val connectorProfileConfig
        : zio.aws.appflow.model.ConnectorProfileConfig.ReadOnly =
      zio.aws.appflow.model.ConnectorProfileConfig
        .wrap(impl.connectorProfileConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.CreateConnectorProfileRequest
  ): zio.aws.appflow.model.CreateConnectorProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
