package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.ConnectorProfileArn
import scala.jdk.CollectionConverters._
final case class CreateConnectorProfileResponse(
    connectorProfileArn: Optional[ConnectorProfileArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.CreateConnectorProfileResponse = {
    import CreateConnectorProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.CreateConnectorProfileResponse
      .builder()
      .optionallyWith(
        connectorProfileArn.map(value =>
          ConnectorProfileArn.unwrap(value): java.lang.String
        )
      )(_.connectorProfileArn)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.CreateConnectorProfileResponse.ReadOnly =
    zio.aws.appflow.model.CreateConnectorProfileResponse.wrap(buildAwsValue())
}
object CreateConnectorProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.CreateConnectorProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.CreateConnectorProfileResponse =
      zio.aws.appflow.model
        .CreateConnectorProfileResponse(connectorProfileArn.map(value => value))
    def connectorProfileArn: Optional[ConnectorProfileArn]
    def getConnectorProfileArn: ZIO[Any, AwsError, ConnectorProfileArn] =
      AwsError.unwrapOptionField("connectorProfileArn", connectorProfileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.CreateConnectorProfileResponse
  ) extends zio.aws.appflow.model.CreateConnectorProfileResponse.ReadOnly {
    override val connectorProfileArn: Optional[ConnectorProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProfileArn())
        .map(value =>
          zio.aws.appflow.model.primitives.ConnectorProfileArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.CreateConnectorProfileResponse
  ): zio.aws.appflow.model.CreateConnectorProfileResponse.ReadOnly =
    new Wrapper(impl)
}
