package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  CredentialsMapValue,
  CredentialsMapKey,
  CustomAuthenticationType
}
import scala.jdk.CollectionConverters._
final case class CustomAuthCredentials(
    customAuthenticationType: CustomAuthenticationType,
    credentialsMap: Optional[Map[CredentialsMapKey, CredentialsMapValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.CustomAuthCredentials = {
    import CustomAuthCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.CustomAuthCredentials
      .builder()
      .customAuthenticationType(
        CustomAuthenticationType.unwrap(
          customAuthenticationType
        ): java.lang.String
      )
      .optionallyWith(
        credentialsMap.map(value =>
          value
            .map({ case (key, value) =>
              (CredentialsMapKey
                .unwrap(key): java.lang.String) -> (CredentialsMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.credentialsMap)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.CustomAuthCredentials.ReadOnly =
    zio.aws.appflow.model.CustomAuthCredentials.wrap(buildAwsValue())
}
object CustomAuthCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.CustomAuthCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.CustomAuthCredentials =
      zio.aws.appflow.model.CustomAuthCredentials(
        customAuthenticationType,
        credentialsMap.map(value => value)
      )
    def customAuthenticationType: CustomAuthenticationType
    def credentialsMap: Optional[Map[CredentialsMapKey, CredentialsMapValue]]
    def getCustomAuthenticationType
        : ZIO[Any, Nothing, CustomAuthenticationType] =
      ZIO.succeed(customAuthenticationType)
    def getCredentialsMap
        : ZIO[Any, AwsError, Map[CredentialsMapKey, CredentialsMapValue]] =
      AwsError.unwrapOptionField("credentialsMap", credentialsMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.CustomAuthCredentials
  ) extends zio.aws.appflow.model.CustomAuthCredentials.ReadOnly {
    override val customAuthenticationType: CustomAuthenticationType =
      zio.aws.appflow.model.primitives
        .CustomAuthenticationType(impl.customAuthenticationType())
    override val credentialsMap
        : Optional[Map[CredentialsMapKey, CredentialsMapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentialsMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appflow.model.primitives.CredentialsMapKey(
                key
              ) -> zio.aws.appflow.model.primitives.CredentialsMapValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.CustomAuthCredentials
  ): zio.aws.appflow.model.CustomAuthCredentials.ReadOnly = new Wrapper(impl)
}
