package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  CustomPropertyValue,
  CustomPropertyKey,
  Name,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class CustomConnectorDestinationProperties(
    entityName: EntityName,
    errorHandlingConfig: Optional[zio.aws.appflow.model.ErrorHandlingConfig] =
      Optional.Absent,
    writeOperationType: Optional[zio.aws.appflow.model.WriteOperationType] =
      Optional.Absent,
    idFieldNames: Optional[Iterable[Name]] = Optional.Absent,
    customProperties: Optional[Map[CustomPropertyKey, CustomPropertyValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.CustomConnectorDestinationProperties = {
    import CustomConnectorDestinationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.CustomConnectorDestinationProperties
      .builder()
      .entityName(EntityName.unwrap(entityName): java.lang.String)
      .optionallyWith(errorHandlingConfig.map(value => value.buildAwsValue()))(
        _.errorHandlingConfig
      )
      .optionallyWith(writeOperationType.map(value => value.unwrap))(
        _.writeOperationType
      )
      .optionallyWith(
        idFieldNames.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.idFieldNames)
      .optionallyWith(
        customProperties.map(value =>
          value
            .map({ case (key, value) =>
              (CustomPropertyKey
                .unwrap(key): java.lang.String) -> (CustomPropertyValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.customProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.CustomConnectorDestinationProperties.ReadOnly =
    zio.aws.appflow.model.CustomConnectorDestinationProperties
      .wrap(buildAwsValue())
}
object CustomConnectorDestinationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.CustomConnectorDestinationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.CustomConnectorDestinationProperties =
      zio.aws.appflow.model.CustomConnectorDestinationProperties(
        entityName,
        errorHandlingConfig.map(value => value.asEditable),
        writeOperationType.map(value => value),
        idFieldNames.map(value => value),
        customProperties.map(value => value)
      )
    def entityName: EntityName
    def errorHandlingConfig
        : Optional[zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly]
    def writeOperationType: Optional[zio.aws.appflow.model.WriteOperationType]
    def idFieldNames: Optional[List[Name]]
    def customProperties: Optional[Map[CustomPropertyKey, CustomPropertyValue]]
    def getEntityName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(entityName)
    def getErrorHandlingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("errorHandlingConfig", errorHandlingConfig)
    def getWriteOperationType
        : ZIO[Any, AwsError, zio.aws.appflow.model.WriteOperationType] =
      AwsError.unwrapOptionField("writeOperationType", writeOperationType)
    def getIdFieldNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("idFieldNames", idFieldNames)
    def getCustomProperties
        : ZIO[Any, AwsError, Map[CustomPropertyKey, CustomPropertyValue]] =
      AwsError.unwrapOptionField("customProperties", customProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.CustomConnectorDestinationProperties
  ) extends zio.aws.appflow.model.CustomConnectorDestinationProperties.ReadOnly {
    override val entityName: EntityName =
      zio.aws.appflow.model.primitives.EntityName(impl.entityName())
    override val errorHandlingConfig
        : Optional[zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorHandlingConfig())
        .map(value => zio.aws.appflow.model.ErrorHandlingConfig.wrap(value))
    override val writeOperationType
        : Optional[zio.aws.appflow.model.WriteOperationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeOperationType())
        .map(value => zio.aws.appflow.model.WriteOperationType.wrap(value))
    override val idFieldNames: Optional[List[Name]] = zio.aws.core.internal
      .optionalFromNullable(impl.idFieldNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appflow.model.primitives.Name(item)
        }.toList
      )
    override val customProperties
        : Optional[Map[CustomPropertyKey, CustomPropertyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appflow.model.primitives.CustomPropertyKey(
                key
              ) -> zio.aws.appflow.model.primitives.CustomPropertyValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.CustomConnectorDestinationProperties
  ): zio.aws.appflow.model.CustomConnectorDestinationProperties.ReadOnly =
    new Wrapper(impl)
}
