package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomConnectorProfileCredentials(
    authenticationType: zio.aws.appflow.model.AuthenticationType,
    basic: Optional[zio.aws.appflow.model.BasicAuthCredentials] =
      Optional.Absent,
    oauth2: Optional[zio.aws.appflow.model.OAuth2Credentials] = Optional.Absent,
    apiKey: Optional[zio.aws.appflow.model.ApiKeyCredentials] = Optional.Absent,
    custom: Optional[zio.aws.appflow.model.CustomAuthCredentials] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.CustomConnectorProfileCredentials = {
    import CustomConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.CustomConnectorProfileCredentials
      .builder()
      .authenticationType(authenticationType.unwrap)
      .optionallyWith(basic.map(value => value.buildAwsValue()))(_.basic)
      .optionallyWith(oauth2.map(value => value.buildAwsValue()))(_.oauth2)
      .optionallyWith(apiKey.map(value => value.buildAwsValue()))(_.apiKey)
      .optionallyWith(custom.map(value => value.buildAwsValue()))(_.custom)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.CustomConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.CustomConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object CustomConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.CustomConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.CustomConnectorProfileCredentials =
      zio.aws.appflow.model.CustomConnectorProfileCredentials(
        authenticationType,
        basic.map(value => value.asEditable),
        oauth2.map(value => value.asEditable),
        apiKey.map(value => value.asEditable),
        custom.map(value => value.asEditable)
      )
    def authenticationType: zio.aws.appflow.model.AuthenticationType
    def basic: Optional[zio.aws.appflow.model.BasicAuthCredentials.ReadOnly]
    def oauth2: Optional[zio.aws.appflow.model.OAuth2Credentials.ReadOnly]
    def apiKey: Optional[zio.aws.appflow.model.ApiKeyCredentials.ReadOnly]
    def custom: Optional[zio.aws.appflow.model.CustomAuthCredentials.ReadOnly]
    def getAuthenticationType
        : ZIO[Any, Nothing, zio.aws.appflow.model.AuthenticationType] =
      ZIO.succeed(authenticationType)
    def getBasic: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.BasicAuthCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("basic", basic)
    def getOauth2
        : ZIO[Any, AwsError, zio.aws.appflow.model.OAuth2Credentials.ReadOnly] =
      AwsError.unwrapOptionField("oauth2", oauth2)
    def getApiKey
        : ZIO[Any, AwsError, zio.aws.appflow.model.ApiKeyCredentials.ReadOnly] =
      AwsError.unwrapOptionField("apiKey", apiKey)
    def getCustom: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.CustomAuthCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("custom", custom)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.CustomConnectorProfileCredentials
  ) extends zio.aws.appflow.model.CustomConnectorProfileCredentials.ReadOnly {
    override val authenticationType: zio.aws.appflow.model.AuthenticationType =
      zio.aws.appflow.model.AuthenticationType.wrap(impl.authenticationType())
    override val basic
        : Optional[zio.aws.appflow.model.BasicAuthCredentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.basic())
        .map(value => zio.aws.appflow.model.BasicAuthCredentials.wrap(value))
    override val oauth2
        : Optional[zio.aws.appflow.model.OAuth2Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oauth2())
        .map(value => zio.aws.appflow.model.OAuth2Credentials.wrap(value))
    override val apiKey
        : Optional[zio.aws.appflow.model.ApiKeyCredentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiKey())
        .map(value => zio.aws.appflow.model.ApiKeyCredentials.wrap(value))
    override val custom
        : Optional[zio.aws.appflow.model.CustomAuthCredentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.custom())
        .map(value => zio.aws.appflow.model.CustomAuthCredentials.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.CustomConnectorProfileCredentials
  ): zio.aws.appflow.model.CustomConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
