package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  ApiVersion,
  ConnectorProfileName,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class DescribeConnectorEntityRequest(
    connectorEntityName: EntityName,
    connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      Optional.Absent,
    connectorProfileName: Optional[ConnectorProfileName] = Optional.Absent,
    apiVersion: Optional[ApiVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityRequest = {
    import DescribeConnectorEntityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityRequest
      .builder()
      .connectorEntityName(
        EntityName.unwrap(connectorEntityName): java.lang.String
      )
      .optionallyWith(connectorType.map(value => value.unwrap))(_.connectorType)
      .optionallyWith(
        connectorProfileName.map(value =>
          ConnectorProfileName.unwrap(value): java.lang.String
        )
      )(_.connectorProfileName)
      .optionallyWith(
        apiVersion.map(value => ApiVersion.unwrap(value): java.lang.String)
      )(_.apiVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.DescribeConnectorEntityRequest.ReadOnly =
    zio.aws.appflow.model.DescribeConnectorEntityRequest.wrap(buildAwsValue())
}
object DescribeConnectorEntityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeConnectorEntityRequest =
      zio.aws.appflow.model.DescribeConnectorEntityRequest(
        connectorEntityName,
        connectorType.map(value => value),
        connectorProfileName.map(value => value),
        apiVersion.map(value => value)
      )
    def connectorEntityName: EntityName
    def connectorType: Optional[zio.aws.appflow.model.ConnectorType]
    def connectorProfileName: Optional[ConnectorProfileName]
    def apiVersion: Optional[ApiVersion]
    def getConnectorEntityName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(connectorEntityName)
    def getConnectorType
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorType] =
      AwsError.unwrapOptionField("connectorType", connectorType)
    def getConnectorProfileName: ZIO[Any, AwsError, ConnectorProfileName] =
      AwsError.unwrapOptionField("connectorProfileName", connectorProfileName)
    def getApiVersion: ZIO[Any, AwsError, ApiVersion] =
      AwsError.unwrapOptionField("apiVersion", apiVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityRequest
  ) extends zio.aws.appflow.model.DescribeConnectorEntityRequest.ReadOnly {
    override val connectorEntityName: EntityName =
      zio.aws.appflow.model.primitives.EntityName(impl.connectorEntityName())
    override val connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorType())
        .map(value => zio.aws.appflow.model.ConnectorType.wrap(value))
    override val connectorProfileName: Optional[ConnectorProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProfileName())
        .map(value =>
          zio.aws.appflow.model.primitives.ConnectorProfileName(value)
        )
    override val apiVersion: Optional[ApiVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.apiVersion())
      .map(value => zio.aws.appflow.model.primitives.ApiVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityRequest
  ): zio.aws.appflow.model.DescribeConnectorEntityRequest.ReadOnly =
    new Wrapper(impl)
}
