package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeConnectorEntityResponse(
    connectorEntityFields: Iterable[zio.aws.appflow.model.ConnectorEntityField]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityResponse = {
    import DescribeConnectorEntityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityResponse
      .builder()
      .connectorEntityFields(connectorEntityFields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.DescribeConnectorEntityResponse.ReadOnly =
    zio.aws.appflow.model.DescribeConnectorEntityResponse.wrap(buildAwsValue())
}
object DescribeConnectorEntityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeConnectorEntityResponse =
      zio.aws.appflow.model
        .DescribeConnectorEntityResponse(connectorEntityFields.map { item =>
          item.asEditable
        })
    def connectorEntityFields
        : List[zio.aws.appflow.model.ConnectorEntityField.ReadOnly]
    def getConnectorEntityFields: ZIO[Any, Nothing, List[
      zio.aws.appflow.model.ConnectorEntityField.ReadOnly
    ]] = ZIO.succeed(connectorEntityFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityResponse
  ) extends zio.aws.appflow.model.DescribeConnectorEntityResponse.ReadOnly {
    override val connectorEntityFields
        : List[zio.aws.appflow.model.ConnectorEntityField.ReadOnly] = impl
      .connectorEntityFields()
      .asScala
      .map { item =>
        zio.aws.appflow.model.ConnectorEntityField.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityResponse
  ): zio.aws.appflow.model.DescribeConnectorEntityResponse.ReadOnly =
    new Wrapper(impl)
}
