package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{
  NextToken,
  MaxResults,
  ConnectorLabel,
  ConnectorProfileName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeConnectorProfilesRequest(
    connectorProfileNames: Optional[Iterable[ConnectorProfileName]] =
      Optional.Absent,
    connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      Optional.Absent,
    connectorLabel: Optional[ConnectorLabel] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest = {
    import DescribeConnectorProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest
      .builder()
      .optionallyWith(
        connectorProfileNames.map(value =>
          value.map { item =>
            ConnectorProfileName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.connectorProfileNames)
      .optionallyWith(connectorType.map(value => value.unwrap))(_.connectorType)
      .optionallyWith(
        connectorLabel.map(value =>
          ConnectorLabel.unwrap(value): java.lang.String
        )
      )(_.connectorLabel)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.DescribeConnectorProfilesRequest.ReadOnly =
    zio.aws.appflow.model.DescribeConnectorProfilesRequest.wrap(buildAwsValue())
}
object DescribeConnectorProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeConnectorProfilesRequest =
      zio.aws.appflow.model.DescribeConnectorProfilesRequest(
        connectorProfileNames.map(value => value),
        connectorType.map(value => value),
        connectorLabel.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def connectorProfileNames: Optional[List[ConnectorProfileName]]
    def connectorType: Optional[zio.aws.appflow.model.ConnectorType]
    def connectorLabel: Optional[ConnectorLabel]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getConnectorProfileNames
        : ZIO[Any, AwsError, List[ConnectorProfileName]] =
      AwsError.unwrapOptionField("connectorProfileNames", connectorProfileNames)
    def getConnectorType
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorType] =
      AwsError.unwrapOptionField("connectorType", connectorType)
    def getConnectorLabel: ZIO[Any, AwsError, ConnectorLabel] =
      AwsError.unwrapOptionField("connectorLabel", connectorLabel)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest
  ) extends zio.aws.appflow.model.DescribeConnectorProfilesRequest.ReadOnly {
    override val connectorProfileNames: Optional[List[ConnectorProfileName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProfileNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.primitives.ConnectorProfileName(item)
          }.toList
        )
    override val connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorType())
        .map(value => zio.aws.appflow.model.ConnectorType.wrap(value))
    override val connectorLabel: Optional[ConnectorLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorLabel())
        .map(value => zio.aws.appflow.model.primitives.ConnectorLabel(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appflow.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appflow.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest
  ): zio.aws.appflow.model.DescribeConnectorProfilesRequest.ReadOnly =
    new Wrapper(impl)
}
