package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeConnectorProfilesResponse(
    connectorProfileDetails: Optional[
      Iterable[zio.aws.appflow.model.ConnectorProfile]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse = {
    import DescribeConnectorProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse
      .builder()
      .optionallyWith(
        connectorProfileDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectorProfileDetails)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.DescribeConnectorProfilesResponse.ReadOnly =
    zio.aws.appflow.model.DescribeConnectorProfilesResponse
      .wrap(buildAwsValue())
}
object DescribeConnectorProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeConnectorProfilesResponse =
      zio.aws.appflow.model.DescribeConnectorProfilesResponse(
        connectorProfileDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connectorProfileDetails
        : Optional[List[zio.aws.appflow.model.ConnectorProfile.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getConnectorProfileDetails: ZIO[Any, AwsError, List[
      zio.aws.appflow.model.ConnectorProfile.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "connectorProfileDetails",
      connectorProfileDetails
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse
  ) extends zio.aws.appflow.model.DescribeConnectorProfilesResponse.ReadOnly {
    override val connectorProfileDetails
        : Optional[List[zio.aws.appflow.model.ConnectorProfile.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProfileDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.ConnectorProfile.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appflow.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse
  ): zio.aws.appflow.model.DescribeConnectorProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
