package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeConnectorsResponse(
    connectorConfigurations: Optional[Map[
      zio.aws.appflow.model.ConnectorType,
      zio.aws.appflow.model.ConnectorConfiguration
    ]] = Optional.Absent,
    connectors: Optional[Iterable[zio.aws.appflow.model.ConnectorDetail]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse = {
    import DescribeConnectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse
      .builder()
      .optionallyWith(
        connectorConfigurations.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.connectorConfigurationsWithStrings)
      .optionallyWith(
        connectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectors)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.DescribeConnectorsResponse.ReadOnly =
    zio.aws.appflow.model.DescribeConnectorsResponse.wrap(buildAwsValue())
}
object DescribeConnectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeConnectorsResponse =
      zio.aws.appflow.model.DescribeConnectorsResponse(
        connectorConfigurations.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        connectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connectorConfigurations: Optional[Map[
      zio.aws.appflow.model.ConnectorType,
      zio.aws.appflow.model.ConnectorConfiguration.ReadOnly
    ]]
    def connectors
        : Optional[List[zio.aws.appflow.model.ConnectorDetail.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getConnectorConfigurations: ZIO[Any, AwsError, Map[
      zio.aws.appflow.model.ConnectorType,
      zio.aws.appflow.model.ConnectorConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "connectorConfigurations",
      connectorConfigurations
    )
    def getConnectors: ZIO[Any, AwsError, List[
      zio.aws.appflow.model.ConnectorDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("connectors", connectors)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse
  ) extends zio.aws.appflow.model.DescribeConnectorsResponse.ReadOnly {
    override val connectorConfigurations: Optional[Map[
      zio.aws.appflow.model.ConnectorType,
      zio.aws.appflow.model.ConnectorConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorConfigurations())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appflow.model.ConnectorType.wrap(
              key
            ) -> zio.aws.appflow.model.ConnectorConfiguration.wrap(value)
          })
          .toMap
      )
    override val connectors
        : Optional[List[zio.aws.appflow.model.ConnectorDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.ConnectorDetail.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appflow.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse
  ): zio.aws.appflow.model.DescribeConnectorsResponse.ReadOnly = new Wrapper(
    impl
  )
}
