package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{NextToken, MaxResults, FlowName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeFlowExecutionRecordsRequest(
    flowName: FlowName,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest = {
    import DescribeFlowExecutionRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest
      .builder()
      .flowName(FlowName.unwrap(flowName): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.DescribeFlowExecutionRecordsRequest.ReadOnly =
    zio.aws.appflow.model.DescribeFlowExecutionRecordsRequest
      .wrap(buildAwsValue())
}
object DescribeFlowExecutionRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeFlowExecutionRecordsRequest =
      zio.aws.appflow.model.DescribeFlowExecutionRecordsRequest(
        flowName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def flowName: FlowName
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getFlowName: ZIO[Any, Nothing, FlowName] = ZIO.succeed(flowName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest
  ) extends zio.aws.appflow.model.DescribeFlowExecutionRecordsRequest.ReadOnly {
    override val flowName: FlowName =
      zio.aws.appflow.model.primitives.FlowName(impl.flowName())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appflow.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appflow.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest
  ): zio.aws.appflow.model.DescribeFlowExecutionRecordsRequest.ReadOnly =
    new Wrapper(impl)
}
