package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeFlowExecutionRecordsResponse(
    flowExecutions: Optional[Iterable[zio.aws.appflow.model.ExecutionRecord]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse = {
    import DescribeFlowExecutionRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse
      .builder()
      .optionallyWith(
        flowExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.flowExecutions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse.ReadOnly =
    zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse
      .wrap(buildAwsValue())
}
object DescribeFlowExecutionRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse =
      zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse(
        flowExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def flowExecutions
        : Optional[List[zio.aws.appflow.model.ExecutionRecord.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getFlowExecutions: ZIO[Any, AwsError, List[
      zio.aws.appflow.model.ExecutionRecord.ReadOnly
    ]] = AwsError.unwrapOptionField("flowExecutions", flowExecutions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse
  ) extends zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse.ReadOnly {
    override val flowExecutions
        : Optional[List[zio.aws.appflow.model.ExecutionRecord.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowExecutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.ExecutionRecord.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appflow.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse
  ): zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse.ReadOnly =
    new Wrapper(impl)
}
