package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.FlowName
import scala.jdk.CollectionConverters._
final case class DescribeFlowRequest(flowName: FlowName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeFlowRequest = {
    import DescribeFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeFlowRequest
      .builder()
      .flowName(FlowName.unwrap(flowName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.DescribeFlowRequest.ReadOnly =
    zio.aws.appflow.model.DescribeFlowRequest.wrap(buildAwsValue())
}
object DescribeFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeFlowRequest =
      zio.aws.appflow.model.DescribeFlowRequest(flowName)
    def flowName: FlowName
    def getFlowName: ZIO[Any, Nothing, FlowName] = ZIO.succeed(flowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeFlowRequest
  ) extends zio.aws.appflow.model.DescribeFlowRequest.ReadOnly {
    override val flowName: FlowName =
      zio.aws.appflow.model.primitives.FlowName(impl.flowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeFlowRequest
  ): zio.aws.appflow.model.DescribeFlowRequest.ReadOnly = new Wrapper(impl)
}
