package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DestinationConnectorProperties(
    redshift: Optional[zio.aws.appflow.model.RedshiftDestinationProperties] =
      Optional.Absent,
    s3: Optional[zio.aws.appflow.model.S3DestinationProperties] =
      Optional.Absent,
    salesforce: Optional[
      zio.aws.appflow.model.SalesforceDestinationProperties
    ] = Optional.Absent,
    snowflake: Optional[zio.aws.appflow.model.SnowflakeDestinationProperties] =
      Optional.Absent,
    eventBridge: Optional[
      zio.aws.appflow.model.EventBridgeDestinationProperties
    ] = Optional.Absent,
    lookoutMetrics: Optional[
      zio.aws.appflow.model.LookoutMetricsDestinationProperties
    ] = Optional.Absent,
    upsolver: Optional[zio.aws.appflow.model.UpsolverDestinationProperties] =
      Optional.Absent,
    honeycode: Optional[zio.aws.appflow.model.HoneycodeDestinationProperties] =
      Optional.Absent,
    customerProfiles: Optional[
      zio.aws.appflow.model.CustomerProfilesDestinationProperties
    ] = Optional.Absent,
    zendesk: Optional[zio.aws.appflow.model.ZendeskDestinationProperties] =
      Optional.Absent,
    marketo: Optional[zio.aws.appflow.model.MarketoDestinationProperties] =
      Optional.Absent,
    customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorDestinationProperties
    ] = Optional.Absent,
    sapoData: Optional[zio.aws.appflow.model.SAPODataDestinationProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DestinationConnectorProperties = {
    import DestinationConnectorProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DestinationConnectorProperties
      .builder()
      .optionallyWith(redshift.map(value => value.buildAwsValue()))(_.redshift)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .optionallyWith(salesforce.map(value => value.buildAwsValue()))(
        _.salesforce
      )
      .optionallyWith(snowflake.map(value => value.buildAwsValue()))(
        _.snowflake
      )
      .optionallyWith(eventBridge.map(value => value.buildAwsValue()))(
        _.eventBridge
      )
      .optionallyWith(lookoutMetrics.map(value => value.buildAwsValue()))(
        _.lookoutMetrics
      )
      .optionallyWith(upsolver.map(value => value.buildAwsValue()))(_.upsolver)
      .optionallyWith(honeycode.map(value => value.buildAwsValue()))(
        _.honeycode
      )
      .optionallyWith(customerProfiles.map(value => value.buildAwsValue()))(
        _.customerProfiles
      )
      .optionallyWith(zendesk.map(value => value.buildAwsValue()))(_.zendesk)
      .optionallyWith(marketo.map(value => value.buildAwsValue()))(_.marketo)
      .optionallyWith(customConnector.map(value => value.buildAwsValue()))(
        _.customConnector
      )
      .optionallyWith(sapoData.map(value => value.buildAwsValue()))(_.sapoData)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.DestinationConnectorProperties.ReadOnly =
    zio.aws.appflow.model.DestinationConnectorProperties.wrap(buildAwsValue())
}
object DestinationConnectorProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DestinationConnectorProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DestinationConnectorProperties =
      zio.aws.appflow.model.DestinationConnectorProperties(
        redshift.map(value => value.asEditable),
        s3.map(value => value.asEditable),
        salesforce.map(value => value.asEditable),
        snowflake.map(value => value.asEditable),
        eventBridge.map(value => value.asEditable),
        lookoutMetrics.map(value => value.asEditable),
        upsolver.map(value => value.asEditable),
        honeycode.map(value => value.asEditable),
        customerProfiles.map(value => value.asEditable),
        zendesk.map(value => value.asEditable),
        marketo.map(value => value.asEditable),
        customConnector.map(value => value.asEditable),
        sapoData.map(value => value.asEditable)
      )
    def redshift
        : Optional[zio.aws.appflow.model.RedshiftDestinationProperties.ReadOnly]
    def s3: Optional[zio.aws.appflow.model.S3DestinationProperties.ReadOnly]
    def salesforce: Optional[
      zio.aws.appflow.model.SalesforceDestinationProperties.ReadOnly
    ]
    def snowflake: Optional[
      zio.aws.appflow.model.SnowflakeDestinationProperties.ReadOnly
    ]
    def eventBridge: Optional[
      zio.aws.appflow.model.EventBridgeDestinationProperties.ReadOnly
    ]
    def lookoutMetrics: Optional[
      zio.aws.appflow.model.LookoutMetricsDestinationProperties.ReadOnly
    ]
    def upsolver
        : Optional[zio.aws.appflow.model.UpsolverDestinationProperties.ReadOnly]
    def honeycode: Optional[
      zio.aws.appflow.model.HoneycodeDestinationProperties.ReadOnly
    ]
    def customerProfiles: Optional[
      zio.aws.appflow.model.CustomerProfilesDestinationProperties.ReadOnly
    ]
    def zendesk
        : Optional[zio.aws.appflow.model.ZendeskDestinationProperties.ReadOnly]
    def marketo
        : Optional[zio.aws.appflow.model.MarketoDestinationProperties.ReadOnly]
    def customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorDestinationProperties.ReadOnly
    ]
    def sapoData
        : Optional[zio.aws.appflow.model.SAPODataDestinationProperties.ReadOnly]
    def getRedshift: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.RedshiftDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("redshift", redshift)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.S3DestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
    def getSalesforce: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SalesforceDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("salesforce", salesforce)
    def getSnowflake: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SnowflakeDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("snowflake", snowflake)
    def getEventBridge: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.EventBridgeDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("eventBridge", eventBridge)
    def getLookoutMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.LookoutMetricsDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("lookoutMetrics", lookoutMetrics)
    def getUpsolver: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.UpsolverDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("upsolver", upsolver)
    def getHoneycode: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.HoneycodeDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("honeycode", honeycode)
    def getCustomerProfiles: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.CustomerProfilesDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("customerProfiles", customerProfiles)
    def getZendesk: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ZendeskDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("zendesk", zendesk)
    def getMarketo: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.MarketoDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("marketo", marketo)
    def getCustomConnector: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.CustomConnectorDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("customConnector", customConnector)
    def getSapoData: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SAPODataDestinationProperties.ReadOnly
    ] = AwsError.unwrapOptionField("sapoData", sapoData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DestinationConnectorProperties
  ) extends zio.aws.appflow.model.DestinationConnectorProperties.ReadOnly {
    override val redshift: Optional[
      zio.aws.appflow.model.RedshiftDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.redshift())
      .map(value =>
        zio.aws.appflow.model.RedshiftDestinationProperties.wrap(value)
      )
    override val s3
        : Optional[zio.aws.appflow.model.S3DestinationProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.appflow.model.S3DestinationProperties.wrap(value))
    override val salesforce: Optional[
      zio.aws.appflow.model.SalesforceDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.salesforce())
      .map(value =>
        zio.aws.appflow.model.SalesforceDestinationProperties.wrap(value)
      )
    override val snowflake: Optional[
      zio.aws.appflow.model.SnowflakeDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.snowflake())
      .map(value =>
        zio.aws.appflow.model.SnowflakeDestinationProperties.wrap(value)
      )
    override val eventBridge: Optional[
      zio.aws.appflow.model.EventBridgeDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventBridge())
      .map(value =>
        zio.aws.appflow.model.EventBridgeDestinationProperties.wrap(value)
      )
    override val lookoutMetrics: Optional[
      zio.aws.appflow.model.LookoutMetricsDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lookoutMetrics())
      .map(value =>
        zio.aws.appflow.model.LookoutMetricsDestinationProperties.wrap(value)
      )
    override val upsolver: Optional[
      zio.aws.appflow.model.UpsolverDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.upsolver())
      .map(value =>
        zio.aws.appflow.model.UpsolverDestinationProperties.wrap(value)
      )
    override val honeycode: Optional[
      zio.aws.appflow.model.HoneycodeDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.honeycode())
      .map(value =>
        zio.aws.appflow.model.HoneycodeDestinationProperties.wrap(value)
      )
    override val customerProfiles: Optional[
      zio.aws.appflow.model.CustomerProfilesDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customerProfiles())
      .map(value =>
        zio.aws.appflow.model.CustomerProfilesDestinationProperties.wrap(value)
      )
    override val zendesk: Optional[
      zio.aws.appflow.model.ZendeskDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.zendesk())
      .map(value =>
        zio.aws.appflow.model.ZendeskDestinationProperties.wrap(value)
      )
    override val marketo: Optional[
      zio.aws.appflow.model.MarketoDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.marketo())
      .map(value =>
        zio.aws.appflow.model.MarketoDestinationProperties.wrap(value)
      )
    override val customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customConnector())
      .map(value =>
        zio.aws.appflow.model.CustomConnectorDestinationProperties.wrap(value)
      )
    override val sapoData: Optional[
      zio.aws.appflow.model.SAPODataDestinationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sapoData())
      .map(value =>
        zio.aws.appflow.model.SAPODataDestinationProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DestinationConnectorProperties
  ): zio.aws.appflow.model.DestinationConnectorProperties.ReadOnly =
    new Wrapper(impl)
}
