package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{ConnectorProfileName, ApiVersion}
import scala.jdk.CollectionConverters._
final case class DestinationFlowConfig(
    connectorType: zio.aws.appflow.model.ConnectorType,
    apiVersion: Optional[ApiVersion] = Optional.Absent,
    connectorProfileName: Optional[ConnectorProfileName] = Optional.Absent,
    destinationConnectorProperties: zio.aws.appflow.model.DestinationConnectorProperties
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DestinationFlowConfig = {
    import DestinationFlowConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DestinationFlowConfig
      .builder()
      .connectorType(connectorType.unwrap)
      .optionallyWith(
        apiVersion.map(value => ApiVersion.unwrap(value): java.lang.String)
      )(_.apiVersion)
      .optionallyWith(
        connectorProfileName.map(value =>
          ConnectorProfileName.unwrap(value): java.lang.String
        )
      )(_.connectorProfileName)
      .destinationConnectorProperties(
        destinationConnectorProperties.buildAwsValue()
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.DestinationFlowConfig.ReadOnly =
    zio.aws.appflow.model.DestinationFlowConfig.wrap(buildAwsValue())
}
object DestinationFlowConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DestinationFlowConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DestinationFlowConfig =
      zio.aws.appflow.model.DestinationFlowConfig(
        connectorType,
        apiVersion.map(value => value),
        connectorProfileName.map(value => value),
        destinationConnectorProperties.asEditable
      )
    def connectorType: zio.aws.appflow.model.ConnectorType
    def apiVersion: Optional[ApiVersion]
    def connectorProfileName: Optional[ConnectorProfileName]
    def destinationConnectorProperties
        : zio.aws.appflow.model.DestinationConnectorProperties.ReadOnly
    def getConnectorType
        : ZIO[Any, Nothing, zio.aws.appflow.model.ConnectorType] =
      ZIO.succeed(connectorType)
    def getApiVersion: ZIO[Any, AwsError, ApiVersion] =
      AwsError.unwrapOptionField("apiVersion", apiVersion)
    def getConnectorProfileName: ZIO[Any, AwsError, ConnectorProfileName] =
      AwsError.unwrapOptionField("connectorProfileName", connectorProfileName)
    def getDestinationConnectorProperties: ZIO[
      Any,
      Nothing,
      zio.aws.appflow.model.DestinationConnectorProperties.ReadOnly
    ] = ZIO.succeed(destinationConnectorProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DestinationFlowConfig
  ) extends zio.aws.appflow.model.DestinationFlowConfig.ReadOnly {
    override val connectorType: zio.aws.appflow.model.ConnectorType =
      zio.aws.appflow.model.ConnectorType.wrap(impl.connectorType())
    override val apiVersion: Optional[ApiVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.apiVersion())
      .map(value => zio.aws.appflow.model.primitives.ApiVersion(value))
    override val connectorProfileName: Optional[ConnectorProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProfileName())
        .map(value =>
          zio.aws.appflow.model.primitives.ConnectorProfileName(value)
        )
    override val destinationConnectorProperties
        : zio.aws.appflow.model.DestinationConnectorProperties.ReadOnly =
      zio.aws.appflow.model.DestinationConnectorProperties
        .wrap(impl.destinationConnectorProperties())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DestinationFlowConfig
  ): zio.aws.appflow.model.DestinationFlowConfig.ReadOnly = new Wrapper(impl)
}
