package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.InstanceUrl
import scala.jdk.CollectionConverters._
final case class DynatraceConnectorProfileProperties(instanceUrl: InstanceUrl) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DynatraceConnectorProfileProperties = {
    import DynatraceConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DynatraceConnectorProfileProperties
      .builder()
      .instanceUrl(InstanceUrl.unwrap(instanceUrl): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.DynatraceConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.DynatraceConnectorProfileProperties
      .wrap(buildAwsValue())
}
object DynatraceConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DynatraceConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DynatraceConnectorProfileProperties =
      zio.aws.appflow.model.DynatraceConnectorProfileProperties(instanceUrl)
    def instanceUrl: InstanceUrl
    def getInstanceUrl: ZIO[Any, Nothing, InstanceUrl] =
      ZIO.succeed(instanceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DynatraceConnectorProfileProperties
  ) extends zio.aws.appflow.model.DynatraceConnectorProfileProperties.ReadOnly {
    override val instanceUrl: InstanceUrl =
      zio.aws.appflow.model.primitives.InstanceUrl(impl.instanceUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DynatraceConnectorProfileProperties
  ): zio.aws.appflow.model.DynatraceConnectorProfileProperties.ReadOnly =
    new Wrapper(impl)
}
