package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.ExecutionMessage
import scala.jdk.CollectionConverters._
final case class ErrorInfo(
    putFailuresCount: Optional[Long] = Optional.Absent,
    executionMessage: Optional[ExecutionMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ErrorInfo = {
    import ErrorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ErrorInfo
      .builder()
      .optionallyWith(putFailuresCount.map(value => value: java.lang.Long))(
        _.putFailuresCount
      )
      .optionallyWith(
        executionMessage.map(value =>
          ExecutionMessage.unwrap(value): java.lang.String
        )
      )(_.executionMessage)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ErrorInfo.ReadOnly =
    zio.aws.appflow.model.ErrorInfo.wrap(buildAwsValue())
}
object ErrorInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appflow.model.ErrorInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ErrorInfo =
      zio.aws.appflow.model.ErrorInfo(
        putFailuresCount.map(value => value),
        executionMessage.map(value => value)
      )
    def putFailuresCount: Optional[Long]
    def executionMessage: Optional[ExecutionMessage]
    def getPutFailuresCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("putFailuresCount", putFailuresCount)
    def getExecutionMessage: ZIO[Any, AwsError, ExecutionMessage] =
      AwsError.unwrapOptionField("executionMessage", executionMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ErrorInfo
  ) extends zio.aws.appflow.model.ErrorInfo.ReadOnly {
    override val putFailuresCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.putFailuresCount())
      .map(value => value: Long)
    override val executionMessage: Optional[ExecutionMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionMessage())
        .map(value => zio.aws.appflow.model.primitives.ExecutionMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ErrorInfo
  ): zio.aws.appflow.model.ErrorInfo.ReadOnly = new Wrapper(impl)
}
