package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecutionResult(
    errorInfo: Optional[zio.aws.appflow.model.ErrorInfo] = Optional.Absent,
    bytesProcessed: Optional[Long] = Optional.Absent,
    bytesWritten: Optional[Long] = Optional.Absent,
    recordsProcessed: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ExecutionResult = {
    import ExecutionResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ExecutionResult
      .builder()
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .optionallyWith(bytesProcessed.map(value => value: java.lang.Long))(
        _.bytesProcessed
      )
      .optionallyWith(bytesWritten.map(value => value: java.lang.Long))(
        _.bytesWritten
      )
      .optionallyWith(recordsProcessed.map(value => value: java.lang.Long))(
        _.recordsProcessed
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ExecutionResult.ReadOnly =
    zio.aws.appflow.model.ExecutionResult.wrap(buildAwsValue())
}
object ExecutionResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ExecutionResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ExecutionResult =
      zio.aws.appflow.model.ExecutionResult(
        errorInfo.map(value => value.asEditable),
        bytesProcessed.map(value => value),
        bytesWritten.map(value => value),
        recordsProcessed.map(value => value)
      )
    def errorInfo: Optional[zio.aws.appflow.model.ErrorInfo.ReadOnly]
    def bytesProcessed: Optional[Long]
    def bytesWritten: Optional[Long]
    def recordsProcessed: Optional[Long]
    def getErrorInfo
        : ZIO[Any, AwsError, zio.aws.appflow.model.ErrorInfo.ReadOnly] =
      AwsError.unwrapOptionField("errorInfo", errorInfo)
    def getBytesProcessed: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesProcessed", bytesProcessed)
    def getBytesWritten: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesWritten", bytesWritten)
    def getRecordsProcessed: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("recordsProcessed", recordsProcessed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ExecutionResult
  ) extends zio.aws.appflow.model.ExecutionResult.ReadOnly {
    override val errorInfo: Optional[zio.aws.appflow.model.ErrorInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorInfo())
        .map(value => zio.aws.appflow.model.ErrorInfo.wrap(value))
    override val bytesProcessed: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesProcessed())
      .map(value => value: Long)
    override val bytesWritten: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesWritten())
      .map(value => value: Long)
    override val recordsProcessed: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.recordsProcessed())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ExecutionResult
  ): zio.aws.appflow.model.ExecutionResult.ReadOnly = new Wrapper(impl)
}
