package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait ExecutionStatus {
  def unwrap: software.amazon.awssdk.services.appflow.model.ExecutionStatus
}
object ExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.ExecutionStatus
  ): zio.aws.appflow.model.ExecutionStatus = value match {
    case software.amazon.awssdk.services.appflow.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.ExecutionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.appflow.model.ExecutionStatus.SUCCESSFUL =>
      val r = Successful
      r
    case software.amazon.awssdk.services.appflow.model.ExecutionStatus.ERROR =>
      val r = Error
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ExecutionStatus =
      software.amazon.awssdk.services.appflow.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.appflow.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ExecutionStatus =
      software.amazon.awssdk.services.appflow.model.ExecutionStatus.IN_PROGRESS
  }
  case object Successful extends zio.aws.appflow.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ExecutionStatus =
      software.amazon.awssdk.services.appflow.model.ExecutionStatus.SUCCESSFUL
  }
  case object Error extends zio.aws.appflow.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ExecutionStatus =
      software.amazon.awssdk.services.appflow.model.ExecutionStatus.ERROR
  }
}
