package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{RefreshToken, AccessToken}
import scala.jdk.CollectionConverters._
final case class HoneycodeConnectorProfileCredentials(
    accessToken: Optional[AccessToken] = Optional.Absent,
    refreshToken: Optional[RefreshToken] = Optional.Absent,
    oAuthRequest: Optional[zio.aws.appflow.model.ConnectorOAuthRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.HoneycodeConnectorProfileCredentials = {
    import HoneycodeConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.HoneycodeConnectorProfileCredentials
      .builder()
      .optionallyWith(
        accessToken.map(value => AccessToken.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(
        refreshToken.map(value => RefreshToken.unwrap(value): java.lang.String)
      )(_.refreshToken)
      .optionallyWith(oAuthRequest.map(value => value.buildAwsValue()))(
        _.oAuthRequest
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.HoneycodeConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.HoneycodeConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object HoneycodeConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.HoneycodeConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.HoneycodeConnectorProfileCredentials =
      zio.aws.appflow.model.HoneycodeConnectorProfileCredentials(
        accessToken.map(value => value),
        refreshToken.map(value => value),
        oAuthRequest.map(value => value.asEditable)
      )
    def accessToken: Optional[AccessToken]
    def refreshToken: Optional[RefreshToken]
    def oAuthRequest
        : Optional[zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly]
    def getAccessToken: ZIO[Any, AwsError, AccessToken] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getRefreshToken: ZIO[Any, AwsError, RefreshToken] =
      AwsError.unwrapOptionField("refreshToken", refreshToken)
    def getOAuthRequest: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly
    ] = AwsError.unwrapOptionField("oAuthRequest", oAuthRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.HoneycodeConnectorProfileCredentials
  ) extends zio.aws.appflow.model.HoneycodeConnectorProfileCredentials.ReadOnly {
    override val accessToken: Optional[AccessToken] = zio.aws.core.internal
      .optionalFromNullable(impl.accessToken())
      .map(value => zio.aws.appflow.model.primitives.AccessToken(value))
    override val refreshToken: Optional[RefreshToken] = zio.aws.core.internal
      .optionalFromNullable(impl.refreshToken())
      .map(value => zio.aws.appflow.model.primitives.RefreshToken(value))
    override val oAuthRequest
        : Optional[zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oAuthRequest())
        .map(value => zio.aws.appflow.model.ConnectorOAuthRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.HoneycodeConnectorProfileCredentials
  ): zio.aws.appflow.model.HoneycodeConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
