package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.DatetimeTypeFieldName
import scala.jdk.CollectionConverters._
final case class IncrementalPullConfig(
    datetimeTypeFieldName: Optional[DatetimeTypeFieldName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.IncrementalPullConfig = {
    import IncrementalPullConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.IncrementalPullConfig
      .builder()
      .optionallyWith(
        datetimeTypeFieldName.map(value =>
          DatetimeTypeFieldName.unwrap(value): java.lang.String
        )
      )(_.datetimeTypeFieldName)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.IncrementalPullConfig.ReadOnly =
    zio.aws.appflow.model.IncrementalPullConfig.wrap(buildAwsValue())
}
object IncrementalPullConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.IncrementalPullConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.IncrementalPullConfig =
      zio.aws.appflow.model
        .IncrementalPullConfig(datetimeTypeFieldName.map(value => value))
    def datetimeTypeFieldName: Optional[DatetimeTypeFieldName]
    def getDatetimeTypeFieldName: ZIO[Any, AwsError, DatetimeTypeFieldName] =
      AwsError.unwrapOptionField("datetimeTypeFieldName", datetimeTypeFieldName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.IncrementalPullConfig
  ) extends zio.aws.appflow.model.IncrementalPullConfig.ReadOnly {
    override val datetimeTypeFieldName: Optional[DatetimeTypeFieldName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datetimeTypeFieldName())
        .map(value =>
          zio.aws.appflow.model.primitives.DatetimeTypeFieldName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.IncrementalPullConfig
  ): zio.aws.appflow.model.IncrementalPullConfig.ReadOnly = new Wrapper(impl)
}
