package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.{Key, Username, AccessKeyId}
import scala.jdk.CollectionConverters._
final case class InforNexusConnectorProfileCredentials(
    accessKeyId: AccessKeyId,
    userId: Username,
    secretAccessKey: Key,
    datakey: Key
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.InforNexusConnectorProfileCredentials = {
    import InforNexusConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.InforNexusConnectorProfileCredentials
      .builder()
      .accessKeyId(AccessKeyId.unwrap(accessKeyId): java.lang.String)
      .userId(Username.unwrap(userId): java.lang.String)
      .secretAccessKey(Key.unwrap(secretAccessKey): java.lang.String)
      .datakey(Key.unwrap(datakey): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.InforNexusConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.InforNexusConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object InforNexusConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.InforNexusConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appflow.model.InforNexusConnectorProfileCredentials =
      zio.aws.appflow.model.InforNexusConnectorProfileCredentials(
        accessKeyId,
        userId,
        secretAccessKey,
        datakey
      )
    def accessKeyId: AccessKeyId
    def userId: Username
    def secretAccessKey: Key
    def datakey: Key
    def getAccessKeyId: ZIO[Any, Nothing, AccessKeyId] =
      ZIO.succeed(accessKeyId)
    def getUserId: ZIO[Any, Nothing, Username] = ZIO.succeed(userId)
    def getSecretAccessKey: ZIO[Any, Nothing, Key] =
      ZIO.succeed(secretAccessKey)
    def getDatakey: ZIO[Any, Nothing, Key] = ZIO.succeed(datakey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.InforNexusConnectorProfileCredentials
  ) extends zio.aws.appflow.model.InforNexusConnectorProfileCredentials.ReadOnly {
    override val accessKeyId: AccessKeyId =
      zio.aws.appflow.model.primitives.AccessKeyId(impl.accessKeyId())
    override val userId: Username =
      zio.aws.appflow.model.primitives.Username(impl.userId())
    override val secretAccessKey: Key =
      zio.aws.appflow.model.primitives.Key(impl.secretAccessKey())
    override val datakey: Key =
      zio.aws.appflow.model.primitives.Key(impl.datakey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.InforNexusConnectorProfileCredentials
  ): zio.aws.appflow.model.InforNexusConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
