package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.InstanceUrl
import scala.jdk.CollectionConverters._
final case class InforNexusConnectorProfileProperties(
    instanceUrl: InstanceUrl
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.InforNexusConnectorProfileProperties = {
    import InforNexusConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.InforNexusConnectorProfileProperties
      .builder()
      .instanceUrl(InstanceUrl.unwrap(instanceUrl): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.InforNexusConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.InforNexusConnectorProfileProperties
      .wrap(buildAwsValue())
}
object InforNexusConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.InforNexusConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.InforNexusConnectorProfileProperties =
      zio.aws.appflow.model.InforNexusConnectorProfileProperties(instanceUrl)
    def instanceUrl: InstanceUrl
    def getInstanceUrl: ZIO[Any, Nothing, InstanceUrl] =
      ZIO.succeed(instanceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.InforNexusConnectorProfileProperties
  ) extends zio.aws.appflow.model.InforNexusConnectorProfileProperties.ReadOnly {
    override val instanceUrl: InstanceUrl =
      zio.aws.appflow.model.primitives.InstanceUrl(impl.instanceUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.InforNexusConnectorProfileProperties
  ): zio.aws.appflow.model.InforNexusConnectorProfileProperties.ReadOnly =
    new Wrapper(impl)
}
