package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class LambdaConnectorProvisioningConfig(lambdaArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.LambdaConnectorProvisioningConfig = {
    import LambdaConnectorProvisioningConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.LambdaConnectorProvisioningConfig
      .builder()
      .lambdaArn(ARN.unwrap(lambdaArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.LambdaConnectorProvisioningConfig.ReadOnly =
    zio.aws.appflow.model.LambdaConnectorProvisioningConfig
      .wrap(buildAwsValue())
}
object LambdaConnectorProvisioningConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.LambdaConnectorProvisioningConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.LambdaConnectorProvisioningConfig =
      zio.aws.appflow.model.LambdaConnectorProvisioningConfig(lambdaArn)
    def lambdaArn: ARN
    def getLambdaArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(lambdaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.LambdaConnectorProvisioningConfig
  ) extends zio.aws.appflow.model.LambdaConnectorProvisioningConfig.ReadOnly {
    override val lambdaArn: ARN =
      zio.aws.appflow.model.primitives.ARN(impl.lambdaArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.LambdaConnectorProvisioningConfig
  ): zio.aws.appflow.model.LambdaConnectorProvisioningConfig.ReadOnly =
    new Wrapper(impl)
}
