package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.Group
import scala.jdk.CollectionConverters._
final case class ListConnectorEntitiesResponse(
    connectorEntityMap: Map[Group, Iterable[
      zio.aws.appflow.model.ConnectorEntity
    ]]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesResponse = {
    import ListConnectorEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesResponse
      .builder()
      .connectorEntityMap(
        connectorEntityMap
          .map({ case (key, value) =>
            (Group.unwrap(key): java.lang.String) -> value.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ListConnectorEntitiesResponse.ReadOnly =
    zio.aws.appflow.model.ListConnectorEntitiesResponse.wrap(buildAwsValue())
}
object ListConnectorEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ListConnectorEntitiesResponse =
      zio.aws.appflow.model.ListConnectorEntitiesResponse(
        connectorEntityMap.map({ case (key, value) =>
          key -> value.map { item =>
            item.asEditable
          }
        })
      )
    def connectorEntityMap
        : Map[Group, List[zio.aws.appflow.model.ConnectorEntity.ReadOnly]]
    def getConnectorEntityMap: ZIO[Any, Nothing, Map[Group, List[
      zio.aws.appflow.model.ConnectorEntity.ReadOnly
    ]]] = ZIO.succeed(connectorEntityMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesResponse
  ) extends zio.aws.appflow.model.ListConnectorEntitiesResponse.ReadOnly {
    override val connectorEntityMap
        : Map[Group, List[zio.aws.appflow.model.ConnectorEntity.ReadOnly]] =
      impl
        .connectorEntityMap()
        .asScala
        .map({ case (key, value) =>
          zio.aws.appflow.model.primitives.Group(key) -> value.asScala.map {
            item =>
              zio.aws.appflow.model.ConnectorEntity.wrap(item)
          }.toList
        })
        .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesResponse
  ): zio.aws.appflow.model.ListConnectorEntitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
