package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListConnectorsResponse(
    connectors: Optional[Iterable[zio.aws.appflow.model.ConnectorDetail]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ListConnectorsResponse = {
    import ListConnectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ListConnectorsResponse
      .builder()
      .optionallyWith(
        connectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectors)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ListConnectorsResponse.ReadOnly =
    zio.aws.appflow.model.ListConnectorsResponse.wrap(buildAwsValue())
}
object ListConnectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ListConnectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ListConnectorsResponse =
      zio.aws.appflow.model.ListConnectorsResponse(
        connectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connectors
        : Optional[List[zio.aws.appflow.model.ConnectorDetail.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getConnectors: ZIO[Any, AwsError, List[
      zio.aws.appflow.model.ConnectorDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("connectors", connectors)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ListConnectorsResponse
  ) extends zio.aws.appflow.model.ListConnectorsResponse.ReadOnly {
    override val connectors
        : Optional[List[zio.aws.appflow.model.ConnectorDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.ConnectorDetail.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appflow.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ListConnectorsResponse
  ): zio.aws.appflow.model.ListConnectorsResponse.ReadOnly = new Wrapper(impl)
}
