package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{NextToken, MaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFlowsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ListFlowsRequest = {
    import ListFlowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ListFlowsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ListFlowsRequest.ReadOnly =
    zio.aws.appflow.model.ListFlowsRequest.wrap(buildAwsValue())
}
object ListFlowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ListFlowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ListFlowsRequest =
      zio.aws.appflow.model.ListFlowsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ListFlowsRequest
  ) extends zio.aws.appflow.model.ListFlowsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appflow.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appflow.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ListFlowsRequest
  ): zio.aws.appflow.model.ListFlowsRequest.ReadOnly = new Wrapper(impl)
}
