package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListFlowsResponse(
    flows: Optional[Iterable[zio.aws.appflow.model.FlowDefinition]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ListFlowsResponse = {
    import ListFlowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ListFlowsResponse
      .builder()
      .optionallyWith(
        flows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.flows)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ListFlowsResponse.ReadOnly =
    zio.aws.appflow.model.ListFlowsResponse.wrap(buildAwsValue())
}
object ListFlowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ListFlowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ListFlowsResponse =
      zio.aws.appflow.model.ListFlowsResponse(
        flows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def flows: Optional[List[zio.aws.appflow.model.FlowDefinition.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getFlows: ZIO[Any, AwsError, List[
      zio.aws.appflow.model.FlowDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("flows", flows)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ListFlowsResponse
  ) extends zio.aws.appflow.model.ListFlowsResponse.ReadOnly {
    override val flows
        : Optional[List[zio.aws.appflow.model.FlowDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flows())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.FlowDefinition.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appflow.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ListFlowsResponse
  ): zio.aws.appflow.model.ListFlowsResponse.ReadOnly = new Wrapper(impl)
}
