package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait MarketoConnectorOperator {
  def unwrap
      : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator
}
object MarketoConnectorOperator {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator
  ): zio.aws.appflow.model.MarketoConnectorOperator = value match {
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.PROJECTION =>
      val r = PROJECTION
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.LESS_THAN =>
      val r = LESS_THAN
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.GREATER_THAN =>
      val r = GREATER_THAN
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.BETWEEN =>
      val r = BETWEEN
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.ADDITION =>
      val r = ADDITION
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.MULTIPLICATION =>
      val r = MULTIPLICATION
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.DIVISION =>
      val r = DIVISION
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.SUBTRACTION =>
      val r = SUBTRACTION
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.MASK_ALL =>
      val r = MASK_ALL
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.MASK_FIRST_N =>
      val r = MASK_FIRST_N
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.MASK_LAST_N =>
      val r = MASK_LAST_N
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.VALIDATE_NON_NULL =>
      val r = VALIDATE_NON_NULL
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.VALIDATE_NON_ZERO =>
      val r = VALIDATE_NON_ZERO
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.VALIDATE_NON_NEGATIVE =>
      val r = VALIDATE_NON_NEGATIVE
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.VALIDATE_NUMERIC =>
      val r = VALIDATE_NUMERIC
      r
    case software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.NO_OP =>
      val r = NO_OP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object PROJECTION
      extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.PROJECTION
  }
  case object LESS_THAN extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.LESS_THAN
  }
  case object GREATER_THAN
      extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.GREATER_THAN
  }
  case object BETWEEN extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.BETWEEN
  }
  case object ADDITION extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.ADDITION
  }
  case object MULTIPLICATION
      extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.MULTIPLICATION
  }
  case object DIVISION extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.DIVISION
  }
  case object SUBTRACTION
      extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.SUBTRACTION
  }
  case object MASK_ALL extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.MASK_ALL
  }
  case object MASK_FIRST_N
      extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.MASK_FIRST_N
  }
  case object MASK_LAST_N
      extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.MASK_LAST_N
  }
  case object VALIDATE_NON_NULL
      extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.VALIDATE_NON_NULL
  }
  case object VALIDATE_NON_ZERO
      extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.VALIDATE_NON_ZERO
  }
  case object VALIDATE_NON_NEGATIVE
      extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.VALIDATE_NON_NEGATIVE
  }
  case object VALIDATE_NUMERIC
      extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.VALIDATE_NUMERIC
  }
  case object NO_OP extends zio.aws.appflow.model.MarketoConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator =
      software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator.NO_OP
  }
}
